/*
This file is licensed under the terms of the Globus Toolkit Public
License, found at http://www.globus.org/toolkit/download/license.html.
*/
package org.globus.ogsa.impl.samples.counter.client;

import org.globus.ogsa.samples.counter.CounterPortType;
import org.globus.ogsa.samples.counter.service.CounterServiceGridLocator;
import org.globus.ogsa.utils.GetOpts;

import javax.xml.rpc.Stub;

import java.net.URL;


public class Subtract {
    public static void main(String[] args) {
        String uri;
        CounterServiceGridLocator locator = new CounterServiceGridLocator();

        GetOpts opts =
            new GetOpts(
                "Usage: Subtract [options] <value> <service handle>", 2
            );
        String error = opts.parse(args);

        if (error != null) {
            System.err.println(error);

            return;
        }

        try {
            CounterPortType counter =
                locator.getCounterPort(new URL(opts.getArg(1)));
            opts.setOptions(((Stub) counter));

            int val = counter.subtract(Integer.parseInt(opts.getArg(0)));
            System.out.println("Counter Value:" + val);
        } catch (Exception e) {
            System.err.println(e);
        }
    }
}
