/*
This file is licensed under the terms of the Globus Toolkit Public
License, found at http://www.globus.org/toolkit/download/license.html.
*/
package org.globus.ogsa.impl.samples.counter.logging;

import org.globus.ogsa.impl.samples.counter.basic.CounterImpl;
import org.globus.ogsa.GridContext;
import org.globus.ogsa.GridServiceException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.rmi.RemoteException;


public class CounterLoggingImpl extends CounterImpl {
    static Log logger = LogFactory.getLog(CounterLoggingImpl.class.getName());

    public CounterLoggingImpl() {
        super("Sample Logger Counter");
        logger.debug("Created Counter " + this.hashCode());
    }

    public int add(int val) throws RemoteException {
        logger.debug("Add " + val + " to Counter " + this.hashCode());

        return super.add(val);
    }

    public int subtract(int val) throws RemoteException {
        logger.debug("Subtract " + val + " from Counter " + this.hashCode());

        return super.subtract(val);
    }

    public int getValue() throws RemoteException {
        logger.debug("Get " + this.val + " from Counter ");

        return super.getValue();
    }

    public void preDestroy(GridContext context) throws GridServiceException {
        logger.debug("Counter " + this.hashCode() + "destroyed");
        super.preDestroy(context);
    }
}
