/*
This file is licensed under the terms of the Globus Toolkit Public
License, found at http://www.globus.org/toolkit/download/license.html.
*/
package org.globus.ogsa.impl.samples.counter.notification;

import org.globus.ogsa.GridConstants;
import org.globus.ogsa.GridContext;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.ServiceData;
import org.globus.ogsa.ServiceDataSet;
import org.globus.ogsa.ServiceProperties;

import org.globus.ogsa.impl.ogsi.GridServiceImpl;
import org.globus.ogsa.types.notification.NotificationSourceTopicElement;
import org.globus.ogsa.types.notification.NotificationSourceTopicType;
import org.globus.ogsa.NotificationProvider;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import java.rmi.RemoteException;
import javax.xml.namespace.QName;

import org.apache.axis.MessageContext;

public class CounterNotificationServiceDataImpl extends GridServiceImpl {
        
        static Log logger = LogFactory.getLog(
             CounterNotificationServiceDataImpl.class.getName());
        
    int val = 0;
    NotificationProvider provider = null;
    public CounterNotificationServiceDataImpl() {
        super("Sample Notification Counter");
    }

    public void postCreate(GridContext context) 
        throws GridServiceException {
	super.postCreate(context);
	this.provider = 
	    (NotificationProvider) getProperty(ServiceProperties.NOTIFICATION_SOURCE);
	addTopic(new QName(GridConstants.NOTIFICATION_TOPIC_NS, 
			   "CounterUpdate"),
		 new QName("http://samples.globus.org/extension/counter",
			   "CounterDataType"));
	addTopic(new QName(GridConstants.NOTIFICATION_TOPIC_NS, 
			   "NegativeCounter"),
		 new QName("http://samples.globus.org/extension/counter",
			   "CounterDataType"));                
    }

    public int add(int val) throws RemoteException {
        this.val += val;
        notifyUpdate();
        return this.val;
    }

    public int subtract(int val) throws RemoteException {
        this.val -= val;
        notifyUpdate();
        return this.val;
    }

    private void notifyUpdate() {
        try {
           logger.debug("In service data counter");
           ServiceDataSet serviceDataSet = getServiceDataSet();
        
      
           QName name  = new QName("http://types.ogsa.globus.org/notification","CounterUpdate");
        
           ServiceData memberData = serviceDataSet.get(name);
           if (memberData != null ) {
               memberData.setValue(CounterDataType.toElement(this.val));
           }
           else {       
              QName list[] = serviceDataSet.getNames();
              for (int i=0;i<list.length;i++) {
                  System.out.println("name=" + list[i].toString());
           }
           
           name  = new QName("http://types.ogsa.globus.org/notification","NegativeCounter");
           memberData = serviceDataSet.get(name);
           memberData.setValue(CounterDataType.toElement(-1 * this.val));
        } 

        serviceDataSet.notifyListeners(memberData);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getValue() throws RemoteException {
        return this.val;
    }
    
    private void addTopic(QName topic, QName messageType)
        throws GridServiceException {
                
        ServiceData serviceData = getServiceDataSet().create(topic);
        NotificationSourceTopicElement topicElement = new NotificationSourceTopicElement();
        NotificationSourceTopicType topicType = new NotificationSourceTopicType();
        topicType.setMessageType(messageType);
        topicElement.setNotificationSourceTopic(topicType);
        serviceData.setValue(topicElement);
        getServiceDataSet().add(serviceData);
    }
}
