/*
This file is licensed under the terms of the Globus Toolkit Public
License, found at http://www.globus.org/toolkit/download/license.html.
*/
package org.globus.ogsa.impl.samples.counter.persistent;

import org.globus.ogsa.impl.ogsi.GridServiceImpl;
import org.globus.ogsa.GridContext;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.samples.counter.CounterPortType;

import java.rmi.RemoteException;


public class PersistentCounterImpl extends GridServiceImpl
    implements CounterPortType {
    protected int val = 0;

    public PersistentCounterImpl() {
        super("Sample Persistent Counter");
    }

    public PersistentCounterImpl(String name) {
        super(name);
    }

    public void postCreate(GridContext context) throws GridServiceException {
	super.postCreate(context);

        String persistedValue = (String) getPersistentProperty("counterValue");

        if (persistedValue != null) {
            val = Integer.parseInt(persistedValue);
        }
    }

    public int add(int val) throws RemoteException {
        this.val = this.val + val;
        save();

        return this.val;
    }

    public int subtract(int val) throws RemoteException {
        this.val = this.val - val;
        save();

        return this.val;
    }

    public int getValue() throws RemoteException {
        return this.val;
    }

    public void save() throws RemoteException {
        try {
            setPersistentProperty("counterValue", String.valueOf(this.val));
            flush();
        } catch (Exception e) {
            throw new RemoteException(e.toString());
        }
    }
}
