/*
This file is licensed under the terms of the Globus Toolkit Public
License, found at http://www.globus.org/toolkit/download/license.html.
*/
package org.globus.ogsa.impl.samples.counter.routable.local;

import org.globus.ogsa.impl.ogsi.GridServiceImpl;
import org.globus.ogsa.impl.samples.counter.secure.CounterImpl;
import org.globus.ogsa.impl.security.authentication.Constants;
import org.globus.ogsa.impl.security.authorization.SelfAuthorization;
import org.globus.ogsa.GridContext;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.ServiceProperties;
import org.globus.ogsa.samples.counter.CounterPortType;

import org.globus.axis.gsi.GSIConstants;

import org.apache.axis.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.xml.namespace.QName;

import java.rmi.RemoteException;

import java.util.HashMap;
import java.util.Map;


public class LocalCounterImpl extends GridServiceImpl {
    private CounterImpl impl;
    private Map notifyProps;
    static Log logger = LogFactory.getLog(LocalCounterImpl.class.getName());

    public LocalCounterImpl() {
        super("Local Counter used in ");
    }

    public void postCreate(GridContext context) throws GridServiceException {
        super.postCreate(context);

        try {
            impl = new CounterImpl(this);
        } catch (Exception e) {
            throw new GridServiceException(e);
        }

        // set up notification properites
        this.notifyProps = new HashMap();

        // detect the incoming msg protection and use that for notification
        this.notifyProps.put(
            Constants.GSI_SEC_CONV,
            context.getMessageContext().getProperty(Constants.GSI_SEC_CONV)
        );

        this.notifyProps.put(
            Constants.AUTHORIZATION, SelfAuthorization.getInstance()
        );

        this.notifyProps.put(
            GSIConstants.GSI_MODE, GSIConstants.GSI_MODE_NO_DELEG
        );
    }

    // service functions
    public void start() throws RemoteException {
        logger.debug("Start called");
    }

    public int add(int val) throws RemoteException {
        logger.debug("Add called");

        int rs = impl.add(val);
        impl.sendNotification(this.notifyProps);

        return rs;
    }

    public int subtract(int val) throws RemoteException {
        int rs = impl.subtract(val);
        impl.sendNotification(this.notifyProps);

        return rs;
    }

    public int getValue() throws RemoteException {
        return impl.getValue();
    }
}
