/*
This file is licensed under the terms of the Globus Toolkit Public
License, found at http://www.globus.org/toolkit/download/license.html.
*/
package org.globus.ogsa.impl.samples.counter.routable.master;

import org.globus.ogsa.GridContext;
import org.globus.ogsa.router.RedirectException;


// Exception that is thrown to redirect the call to a different service
public class HostingEnvRedirectException extends RedirectException {
    private GridContext gridContext;
    private String invocationId;

    public HostingEnvRedirectException(
        String _invocationId,
        GridContext _gridContext
    ) {
        super();
        gridContext = _gridContext;
        invocationId = _invocationId;
    }

    public GridContext getGridContext() {
        return gridContext;
    }

    public String getInvocationId() {
        return invocationId;
    }
}
