/*
This file is licensed under the terms of the Globus Toolkit Public
License, found at http://www.globus.org/toolkit/download/license.html.
*/
package org.globus.ogsa.impl.samples.counter.secure;

import org.ietf.jgss.GSSCredential;

import org.globus.ogsa.impl.ogsi.GridServiceImpl;
import org.globus.ogsa.GridContext;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.samples.counter.CounterPortType;

import org.globus.axis.gsi.GSIConstants;
import org.globus.axis.util.Util;
import org.globus.gsi.gssapi.auth.SelfAuthorization;

import org.apache.axis.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.xml.namespace.QName;

import java.rmi.RemoteException;

import java.util.HashMap;
import java.util.Map;


public class SecureCounterImpl extends GridServiceImpl {
    private CounterImpl impl;
    private Map notifyProps;

    public SecureCounterImpl() {
        super("Sample Secure Counter");

        this.notifyProps = new HashMap();

        this.notifyProps.put(
            GSIConstants.GSI_MODE, GSIConstants.GSI_MODE_NO_DELEG
        );
    }

    public void postCreate(GridContext context) throws GridServiceException {
	super.postCreate(context);
        try {
            impl = new CounterImpl(this);
        } catch (Exception e) {
            throw new GridServiceException(e);
        }
    }

    public int add(int val) throws RemoteException {
        GSSCredential creds =
            Util.getCredentials(MessageContext.getCurrentContext());

        if (creds == null) {
            throw new RemoteException(
                "Credentials are required for this service"
            );
        }

        int rs = impl.add(val);
        sendNotification(creds);

        return rs;
    }

    public int subtract(int val) throws RemoteException {
        GSSCredential creds =
            Util.getCredentials(MessageContext.getCurrentContext());

        if (creds == null) {
            throw new RemoteException(
                "Credentials are required for this service"
            );
        }

        int rs = impl.subtract(val);
        sendNotification(creds);

        return rs;
    }

    public int getValue() throws RemoteException {
        return impl.getValue();
    }

    private void sendNotification(GSSCredential credentials) {
        this.notifyProps.put(
            GSIConstants.GSI_AUTHORIZATION, SelfAuthorization.getInstance()
        );

        this.notifyProps.put(GSIConstants.GSI_CREDENTIALS, credentials);

        impl.sendNotification(this.notifyProps);
    }
}
