/*
This file is licensed under the terms of the Globus Toolkit Public
License, found at http://www.globus.org/toolkit/download/license.html.
*/
package org.globus.ogsa.impl.samples.counter.secure;

import org.ietf.jgss.GSSCredential;

import org.globus.ogsa.impl.ogsi.GridServiceImpl;
import org.globus.ogsa.impl.samples.counter.notification.CounterDataType;
import org.globus.ogsa.impl.security.SecurityManager;
import org.globus.ogsa.impl.security.authentication.Constants;
import org.globus.ogsa.impl.security.authentication.CredentialRefreshListener;
import org.globus.ogsa.impl.security.authorization.SelfAuthorization;
import org.globus.ogsa.GridContext;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.NotificationProvider;
import org.globus.ogsa.ServiceData;
import org.globus.ogsa.ServiceProperties;
import org.globus.ogsa.samples.counter.CounterPortType;

import org.globus.axis.gsi.GSIConstants;

import org.apache.axis.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.xml.namespace.QName;

import java.rmi.RemoteException;

import java.util.HashMap;
import java.util.Map;


public class SoapSecureCounterImpl extends GridServiceImpl
    implements CredentialRefreshListener {
    private int val = 0;
    private Map notifyProps;
    private ServiceData counterData;
    private NotificationProvider source;

    public SoapSecureCounterImpl() {
        super("SOAP Secure Counter");
    }

    public void postCreate(GridContext context) throws GridServiceException {
        super.postCreate(context);

	this.source =
	    (NotificationProvider) getProperty(
                    ServiceProperties.NOTIFICATION_SOURCE
            );
	this.source.addTopic(
		"CounterUpdate",
		new QName("http://samples.globus.org/extension/counter",
			  "CounterDataType"));

        this.counterData = this.serviceData.create("CounterStatus");
        this.counterData.setValue("initialized");
        this.serviceData.add(counterData);

        SecurityManager manager = SecurityManager.getManager();
        manager.setServiceOwnerFromContext(this);

        // set up notification properites
        this.notifyProps = new HashMap();

        // detect the incoming msg protection and use that for notification
        setNotifyProperty(
            Constants.GSI_SEC_CONV,
            context.getMessageContext().getProperty(Constants.GSI_SEC_CONV)
        );

        setNotifyProperty(
            Constants.AUTHORIZATION, SelfAuthorization.getInstance()
        );

        setNotifyProperty(
            GSIConstants.GSI_MODE, GSIConstants.GSI_MODE_NO_DELEG
        );
    }

    public void refreshCredentials(GSSCredential creds) {
        // this will be called 
    }

    private void setNotifyProperty(
        String name,
        Object value
    ) {
        this.notifyProps.put(name, value);
        this.counterData.setProperty(name, value);
    }

    // service functions
    public int add(int val) throws RemoteException {
        checkSecure();
        this.val = this.val + val;
        this.counterData.setValue(String.valueOf(this.val));
        notifySub();

        return this.val;
    }

    public int subtract(int val) throws RemoteException {
        checkSecure();
        this.val = this.val - val;
        this.counterData.setValue(String.valueOf(this.val));
        notifySub();

        return this.val;
    }

    public int getValue() throws RemoteException {
        return this.val;
    }
    
    private void checkSecure() throws RemoteException {
        MessageContext ctx = MessageContext.getCurrentContext();

        if (ctx.getProperty(Constants.CONTEXT) == null) {
            throw new RemoteException("Service requires secure access.");
        }
    }

    private void notifySub() {
        try {
            this.source.notify(
                "CounterUpdate", CounterDataType.toElement(this.val),
                this.notifyProps
            );
            this.counterData.notifyChangeWithAck();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
