/*
This file is licensed under the terms of the Globus Toolkit Public
License, found at http://www.globus.org/toolkit/download/license.html.
*/
package org.globus.ogsa.impl.samples.exception;

import org.globus.ogsa.samples.exception.ExceptionPortType;
import org.globus.ogsa.samples.exception.service.ExceptionServiceGridLocator;

import org.gridforum.ogsi.HandleType;

import java.rmi.RemoteException;


public class Chain {
    public static void main(String[] args) {
        ExceptionServiceGridLocator locator = new ExceptionServiceGridLocator();

        if (args.length < 2) {
            System.err.println("Usage: Chain <from handle> <to handle>");

            return;
        }

        try {
            ExceptionPortType chained =
                locator.getExceptionPort(new HandleType(args[0]));
            chained.chain(new HandleType(args[1]));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
