/*
This file is licensed under the terms of the Globus Toolkit Public
License, found at http://www.globus.org/toolkit/download/license.html.
*/
package org.globus.ogsa.impl.samples.exception;

import org.globus.ogsa.impl.ogsi.GridServiceImpl;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.samples.exception.ExceptionPortType;
import org.globus.ogsa.samples.exception.TestFault;
import org.globus.ogsa.samples.exception.service.ExceptionServiceGridLocator;
import org.globus.ogsa.utils.FaultHelper;

import org.gridforum.ogsi.FaultType;
import org.gridforum.ogsi.HandleType;

import java.rmi.RemoteException;


public class ExceptionImpl extends GridServiceImpl implements ExceptionPortType {
    private ExceptionServiceGridLocator locator =
        new ExceptionServiceGridLocator();
    private ExceptionPortType chained = null;

    public ExceptionImpl() {
        super("Sample Exception Service");
    }

    public void invokeGeneric() throws RemoteException, FaultType {
        if (chained == null) {
            throw FaultHelper.makeFault("end of chain");
        }

        try {
            chained.invokeGeneric();
        } catch (FaultType fault) {
            throw FaultHelper.makeFault("chain " + this.hashCode(), fault);
        }
    }

    public void invokeCustom() throws RemoteException, FaultType, TestFault {
        if (chained == null) {
            throw FaultHelper.makeFault(TestFault.class, "end of chain");
        }

        try {
            chained.invokeCustom();
        } catch (TestFault fault) {
            throw FaultHelper.makeFault(
                TestFault.class, "chain " + this.hashCode(), fault
            );
        }
    }

    public void invokeLocal() throws RemoteException, FaultType {
        if (chained == null) {
            throw new GridServiceException("end of chain");
        }

        try {
            chained.invokeLocal();
        } catch (Exception fault) {
            throw new GridServiceException("chain " + this.hashCode(), fault);
        }
    }

    public void chain(HandleType handle) throws RemoteException {
        chained = locator.getExceptionPort(handle);
    }
}
