/*
This file is licensed under the terms of the Globus Toolkit Public
License, found at http://www.globus.org/toolkit/download/license.html.
*/
package org.globus.ogsa.impl.samples.exception;

import org.globus.ogsa.samples.exception.ExceptionPortType;
import org.globus.ogsa.samples.exception.TestFault;
import org.globus.ogsa.samples.exception.service.ExceptionServiceGridLocator;
import org.globus.ogsa.utils.FaultHelper;

import org.gridforum.ogsi.FaultType;
import org.gridforum.ogsi.HandleType;

import java.rmi.RemoteException;


public class InvokeLocal {
    public static void main(String[] args) {
        ExceptionServiceGridLocator locator = new ExceptionServiceGridLocator();

        if (args.length < 1) {
            System.err.println("Usage: InvokeLocal <handle>");

            return;
        }

        try {
            ExceptionPortType chained =
                locator.getExceptionPort(new HandleType(args[0]));
            chained.invokeLocal();
        } catch (FaultType fault) {
            System.err.println(FaultHelper.toString(fault));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
