/*
This file is licensed under the terms of the Globus Toolkit Public
License, found at http://www.globus.org/toolkit/download/license.html.
*/
package org.globus.ogsa.impl.samples.servicedata;

import org.globus.ogsa.samples.servicedata.ServiceDataPortType;
import org.globus.ogsa.samples.servicedata.service.ServiceDataServiceGridLocator;
import org.globus.ogsa.utils.GetOpts;
import org.globus.ogsa.utils.MessageUtils;

import org.gridforum.ogsi.ExtendedDateTimeType;
import org.gridforum.ogsi.HandleType;

import javax.xml.rpc.Stub;

import java.util.Calendar;


public class AddServiceData {
    public static void main(String[] args) {
        String handle;
        ServiceDataServiceGridLocator locator =
            new ServiceDataServiceGridLocator();

        GetOpts opts =
            new GetOpts(
                "Usage: AddServiceData [options] " +
                "<value> <availableUntil> " + "<service handle>", 3
            );
        String error = opts.parse(args);

        if (error != null) {
            System.err.println(error);

            return;
        }

        try {
            ServiceDataPortType service =
                locator.getServiceDataPort(new HandleType(opts.getArg(2)));
            opts.setOptions(((Stub) service));

            Calendar calendar = Calendar.getInstance();
            calendar.add(Calendar.SECOND, Integer.parseInt(opts.getArg(1)));

            ExtendedDateTimeType timeout = new ExtendedDateTimeType();
            timeout.setValue(calendar);
            service.addServiceData(
                timeout, timeout, timeout, null, opts.getArg(0)
            );
        } catch (Exception e) {
            System.err.println(MessageUtils.toString(e));
        }
    }
}
