/*
This file is licensed under the terms of the Globus Toolkit Public
License, found at http://www.globus.org/toolkit/download/license.html.
*/
package org.globus.ogsa.impl.samples.servicedata;

import org.globus.ogsa.impl.ogsi.PersistentGridServiceImpl;
import org.globus.ogsa.GridConstants;
import org.globus.ogsa.GridContext;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.ServiceData;
import org.globus.ogsa.ServiceDataAttributes;
import org.globus.ogsa.ServiceProperties;
import org.globus.ogsa.samples.servicedata.ServiceDataPortType;

import org.gridforum.ogsi.ExtendedDateTimeType;
import org.gridforum.ogsi.HandleType;

import org.apache.axis.utils.XMLUtils;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import javax.xml.namespace.QName;

import java.rmi.RemoteException;


public class ServiceDataImpl extends PersistentGridServiceImpl
    implements ServiceDataPortType {
    ServiceData sampleServiceData;

    public ServiceDataImpl() {
        super("Service Data Lifecycle Sample");
    }

    public void postPersistentCreate(GridContext context)
        throws GridServiceException {
        this.sampleServiceData =
            this.serviceData.create(
                new QName(GridConstants.GLOBUS_NS, "sampleElement")
            );

        ServiceData myData =
            this.serviceData.create(new QName("urn:mydata", "myData"));
        myData.setModifiable(true);

        ServiceData myData2 =
            this.serviceData.create(new QName("urn:mydata", "myData2"));
        myData2.setModifiable(true);
        this.serviceData.add(myData);
        this.serviceData.add(myData2);

        ServiceData testString =
            this.serviceData.create(new QName("urn:mydata", "testString"));
        testString.setModifiable(true);
        testString.setMutability(ServiceData.MUTABLE);
        this.serviceData.add(testString);

        QName elementQName = new QName("urn:testElement", "myElement");

        try {
            Document doc = XMLUtils.newDocument();
            Element element =
                doc.createElementNS(
                    elementQName.getNamespaceURI(), elementQName.getLocalPart()
                );
            element.setAttribute("customAttribute", "hello");

            ServiceDataAttributes attributes =
                new ServiceDataAttributes(element);
            attributes.setOriginator(
                new HandleType((String) getProperty(ServiceProperties.HANDLE))
            );

            ServiceData elementData = this.serviceData.create(elementQName);
            elementData.setValue(attributes);
            this.serviceData.add(elementData);
        } catch (Exception e) {
            throw new GridServiceException(e);
        }
    }

    public void addServiceData(
        ExtendedDateTimeType availableUntil,
        ExtendedDateTimeType goodUntil,
        ExtendedDateTimeType goodFrom,
        HandleType originator,
        String value
    ) throws RemoteException {
        ServiceDataAttributes attributes = new ServiceDataAttributes(value);
        attributes.setAvailableUntil(availableUntil);
        attributes.setGoodUntil(goodUntil);
        attributes.setGoodFrom(goodFrom);
        attributes.setOriginator(originator);
        this.sampleServiceData.addValue(attributes);
        this.serviceData.add(sampleServiceData);
    }
}
