/*
This file is licensed under the terms of the Globus Toolkit Public
License, found at http://www.globus.org/toolkit/download/license.html.
*/
package org.globus.ogsa.impl.samples.weather.client;

import org.globus.ogsa.samples.weather.WeatherPortType;
import org.globus.ogsa.samples.weather.service.WeatherServiceLocator;

import java.net.URL;


public class GetTemp {
    public static void main(String[] args) {
        String uri;
        WeatherServiceLocator weatherService = new WeatherServiceLocator();

        if (args.length < 1) {
            System.err.println("usage: GetTemp <job url>");

            return;
        }

        try {
            WeatherPortType weather =
                weatherService.getWeatherPort(new URL(args[0]));
            float temp = weather.getTemp();
            System.out.println("Temperature:" + temp);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
