package hello;

import java.math.*;
import javax.xml.rpc.Call;
import javax.xml.rpc.Service;
import javax.xml.rpc.JAXRPCException;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceFactory;
import javax.xml.rpc.ParameterMode;

public class DIIHelloClient
{

    // In the WSDL under definitions. This is the target namespace.
    private static String BODY_NAMESPACE_VALUE = "http://hello.org/wsdl";

    // In the WSDL under types. This is the namespace that is defined for
    // types defined in the WSDL.
    private static String TYPE_NAMESPACE_VALUE = "http://hello.org/types";

    private static String ENCODING_STYLE_PROPERTY =
            "javax.xml.rpc.encodingstyle.namespace.uri";

	 // The endpoint must be supplied by the service deployer or developer.
    String UrlString = "http://localhost:8080/jaxrpc-DocumentLitHelloService/hello?WSDL";

   // Service name from the WSDL.
    String serviceName = "HelloWorldService";

    // Port name from the WSDL.
    String portName = "HelloIFPort";


    Service service = null;
    QName port = null;
    ValueType valueType = null;


    public static void main(String[] args)
    {
        try {
            DIIHelloClient client =  new DIIHelloClient();
            client.testEchoString();
            client.testValueType();
            client.testComplexValueType();
            client.testSimpleIntArray();
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public DIIHelloClient() {
        try {

		 // Get the service factory using the newInstance() method.
            ServiceFactory factory =
                    ServiceFactory.newInstance();

	     // Create the service using the QName of the service.
	     // In this version of the createService() method the location of
	     // the WSDL is supplied. At runtime, the WSDL is examined and the
	     // service is configured using the information from the WSDL.
            service =
                    factory.createService(new java.net.URL(UrlString),
                            new QName(BODY_NAMESPACE_VALUE, serviceName));

		 // Specify the port QName using the portName.
            port = new QName(BODY_NAMESPACE_VALUE, portName);

        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void testEchoString()
    throws Exception
    {

	// Operation QName as specified in the WSDL under portType section.
    // WSDL fragment:
    // <operation name="sayHello">
    // <input message="tns:HelloIF_sayHello"/>
    // <output message="tns:HelloIF_sayHelloResponse"/></operation>
        QName operation = new QName(BODY_NAMESPACE_VALUE, "sayHello");

	// The service is a factory for a call that will be invoked.
	// Even though the service has been configured using the WSDL
	// information, the operation QName must be specified on the
	// Call instance. In other words, the dii client must specify
	// which operation is to be performed.
        Call call = service.createCall(port, operation);

	// For a call object, the developer must set these Call properties.
        call.setProperty(Call.SOAPACTION_USE_PROPERTY,
                new Boolean(true));
        call.setProperty(Call.SOAPACTION_URI_PROPERTY, "");

    // The encoding style property and the operation style property
    // must be set for a WS-I doc/lit or rpc/lit type of invocation
    // Although these properties are specified in the JAX-RPC Specification
    // as optional, the default behavior for this implementation is rpc/encoded.

    // use="literal" in WSDL
        call.setProperty(ENCODING_STYLE_PROPERTY, "");

	// style="document" in WSDL
        call.setProperty(Call.OPERATION_STYLE_PROPERTY, "document");



    // Instantiate the parameter(s) and populate the call Object[] request.
    // Where does the SayHello class come from?. This class must previously be generated by
    // the wscompile tool. The client programmer does not necessarily need to generate these
    // files-- the JAX-RPC service developer may have made them available after service development
    // and deployment. These files should not be coded by the client developer.

    // Note that the parameters and return type are not configured by the dii client
    // program on the call instance. This information was configured on the call instance
    // by the JAXRPC implementation using the WSDL information examined at runtime.
    // This target endpoint is configured the same way.
     System.out.println("Running echo String from a dii client.");
        SayHello request = new SayHello(" Duke says: ", "Java is Everywhere!");
        Object[] params = {request};

	// Invoke sayHello:
        SayHelloResponse response = (SayHelloResponse) call.invoke(params);

	// Print result.
        System.out.println("Response is: " + response.getResult());
        System.out.println(" ");

    }

    public void testValueType()
    throws Exception
    {

        QName operation = new QName(BODY_NAMESPACE_VALUE, "changeValueType");


        Call call = service.createCall(port, operation);


        call.setProperty(Call.SOAPACTION_USE_PROPERTY,
                new Boolean(true));
        call.setProperty(Call.SOAPACTION_URI_PROPERTY, "");


        call.setProperty(ENCODING_STYLE_PROPERTY, "");
        call.setProperty(Call.OPERATION_STYLE_PROPERTY, "document");


        System.out.println("\nRunning SimpleValueType from a dii client using WSDL");
        System.out.println("");
        System.out.println("Original ValueType is: ");
        valueType = new ValueType(true, new Integer(23), "Test Data");
        System.out.println("Echoing the boolean set in ValueType by client :" + valueType.isBoolProperty());
        System.out.println("Echoing the integer set in ValueType by client :" + valueType.getIntegerProperty().intValue());
        System.out.println("Echoing the string set in ValueType by client  :" + valueType.getStringProperty());
        System.out.println("");

        ChangeValueType changeValueType = new ChangeValueType(valueType);
        Object[] params = {changeValueType};

	// Invoke changeValueTypeResponse:
        ChangeValueTypeResponse valueTypeResponse = (ChangeValueTypeResponse) call.invoke(params);

	    ValueType vt = valueTypeResponse.getResult();
        System.out.println("The response from the Server is:");
        System.out.println("Echoing the boolean set in ValueType by server :" + vt.isBoolProperty());
        System.out.println("Echoing the integer set in ValueType by server :" + vt.getIntegerProperty().intValue());
        System.out.println("Echoing the string set in ValueType by server  :" + vt.getStringProperty());

    }

    public void testComplexValueType()
            throws Exception {

        QName operation = new QName(BODY_NAMESPACE_VALUE, "changeComplexValueType");

        Call call = service.createCall(port, operation);

        call.setProperty(Call.SOAPACTION_USE_PROPERTY,
                new Boolean(true));
        call.setProperty(Call.SOAPACTION_URI_PROPERTY, "");

        call.setProperty(ENCODING_STYLE_PROPERTY, "");
        call.setProperty(Call.OPERATION_STYLE_PROPERTY, "document");


        System.out.println("Running ChangeComplexValueType from a dii client.");
        BaseFooObject baseFoo = new BaseFooObject(new BigInteger("12345"), 04, true);

        int[] intArray = {1, 4, 7, 9, 11};
        IntArrayTest simpleArray = new IntArrayTest(intArray);

        ValueTypeWObjectMemberAObjectMemberArray param =
                new ValueTypeWObjectMemberAObjectMemberArray(
                        new java.util.GregorianCalendar(), new java.util.GregorianCalendar(), 129, baseFoo,
                        simpleArray, "fooString");

        ChangeComplexValueType changeComplexValueType = new ChangeComplexValueType(param);
        Object[] params = {changeComplexValueType};

	 // Invoke changeComplexValueType:
        ChangeComplexValueTypeResponse result1 = (ChangeComplexValueTypeResponse)
                call.invoke(params);

	    ValueTypeWObjectMemberAObjectMemberArray result = result1.getResult();
        BaseFooObject rfoo = result.getMyValueType();
        System.out.println("\nRunning ComplexValuType from a dii client using WSDL");
        System.out.println("Client output for testComplexValueType : " + rfoo.getFirst().toString());
        System.out.println("Client output for testComplexValueType : " + rfoo.getSecond());
        System.out.println("Client output for testComplexValueType : " + rfoo.isThird());

        System.out.println("\nOriginal unsigned long in ValueTypeWObjectMemberAObjectMemberArray : 129");
        System.out.println("Modified unsigned long in ValueTypeWObjectMemberAObjectMemberArray  : " + result.getLongUnsignedInt());

    }

    public void testSimpleIntArray()
            throws Exception {

        QName operation = new QName(BODY_NAMESPACE_VALUE, "reverseArray");

        Call call = service.createCall(port, operation);

        call.setProperty(Call.SOAPACTION_USE_PROPERTY,
                new Boolean(true));
        call.setProperty(Call.SOAPACTION_URI_PROPERTY, "");

        call.setProperty(ENCODING_STYLE_PROPERTY, "");
        call.setProperty(Call.OPERATION_STYLE_PROPERTY, "document");

        int[] intArray = {1, 4, 7, 9, 11};
        IntArrayTest param = new IntArrayTest(intArray);
        ReverseArray rArray = new ReverseArray(param);

        Object[] params = {rArray};

	// Invoke reverseArray:
        ReverseArrayResponse result1 = (ReverseArrayResponse) call.invoke(params);

	    IntArrayTest result = result1.getResult();
        int[] rintArray = result.getIntArray();
        System.out.println("\nRunning int[] from a dii client using WSDL");
        System.out.println("Client output for testSimpleIntArray   : " + java.util.Arrays.equals(intArray, rintArray));

    }
}
