package hello;

import java.math.*;
import java.net.URL;
import javax.xml.rpc.Service;
import javax.xml.rpc.JAXRPCException;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceFactory;


public class ProxyHelloClient
{
 // In the WSDL under definitions. This is the target namespace.
     private static String BODY_NAMESPACE_VALUE = "http://hello.org/wsdl";

    // In the WSDL under types. This is the namespace that is defined for
    // types defined in the WSDL.
    private static String TYPE_NAMESPACE_VALUE = "http://hello.org/types";


   // The endpoint must be supplied by the service deployer or developer.
    String UrlString = "http://localhost:8080/jaxrpc-DocumentLitHelloService/hello?WSDL";
   // Service name from the WSDL.
    String serviceName = "HelloWorldService";

    // Port name from the WSDL.
    String portName = "HelloIFPort";

    HelloIF proxy = null;
    ValueType valueType = null;

    public static void main(String[] args)
    {
        try {
            ProxyHelloClient client =  new ProxyHelloClient();
            client.testEchoString();
            client.testValueType();
            client.testComplexValueType();
            client.testSimpleIntArray();
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public ProxyHelloClient() {
        try {

            URL helloWsdlUrl = new URL(UrlString);
         // Get the service factory using the newInstance() method.
            ServiceFactory serviceFactory = ServiceFactory.newInstance();

	     // Create the service using the QName of the service.
	     // In this version of the createService() method the location of
	     // the WSDL is supplied. At runtime, the WSDL is examined and the
	     // service is configured using the information from the WSDL.
            Service helloService = serviceFactory.createService(helloWsdlUrl,
                    new QName(BODY_NAMESPACE_VALUE, serviceName));

	     // The service has been configured with the WSDL information.
         // To create the dynamic proxy that implements the service interface,
         // the Port must be obtained from the service.

         // Where does the HelloIF class come from?  This class must previously be generated by
         // the wscompile tool. The client programmer does not necessarily need to generate these
         // files-- the JAX-RPC service developer may have made them available after service development
         // and deployment. These files should not be coded by the client developer.

            proxy = (HelloIF) helloService.getPort(
                    new QName(BODY_NAMESPACE_VALUE, portName),
                    hello.HelloIF.class);

            valueType = new ValueType(true, new Integer(23), "Test Data");

        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void testEchoString()
            throws Exception {



	// Instantiate the parameter(s)
    // Where does the SayHello class come from?. This class must previously be generated by
    // the wscompile tool. The client programmer does not necessarily need to generate these
    // files-- the JAX-RPC service developer may have made them available after service development
    // and deployment. These files should not be coded by the client developer.
        System.out.println("Running echo String from a Dynamic Proxy client.");
        SayHello request = new SayHello(" Duke says: ", "Java is Everywhere!");

	//Invoke the sayHello() method. The dynamic proxy implements the service endpoint
	//interface (HelloIF). All the client needs to do is invoke the method on the proxy.
        SayHelloResponse response = proxy.sayHello(request);

	//Print results
        System.out.println("Response is: " + response.getResult());
        System.out.println(" ");
    }

    public void testValueType()
            throws Exception {

        System.out.println("\nRunning SimpleValueType from a Dynamic Proxy client.");
        valueType = new ValueType(true, new Integer(23), "Test Data");
        System.out.println("Echoing the boolean set in ValueType by client :" + valueType.isBoolProperty());
        System.out.println("Echoing the integer set in ValueType by client :" + valueType.getIntegerProperty().intValue());
        System.out.println("Echoing the string set in ValueType by client  :" + valueType.getStringProperty());
        System.out.println("");

	//Invoke changeValueType:
        ChangeValueTypeResponse cvt = proxy.changeValueType(new ChangeValueType(valueType));

	    ValueType vt = cvt.getResult();
        System.out.println("The response from the Server is:");
        System.out.println("Echoing the boolean set in ValueType by server :" + vt.isBoolProperty());
        System.out.println("Echoing the integer set in ValueType by server :" + vt.getIntegerProperty().intValue());
        System.out.println("Echoing the string set in ValueType by server  :" + vt.getStringProperty());

    }

    public void testComplexValueType()
            throws Exception {

        BaseFooObject baseFoo = new BaseFooObject(new BigInteger("12345"), 04, true);
        int[] intArray = {1, 4, 7, 9, 11};
        IntArrayTest simpleArray = new IntArrayTest(intArray);

        ValueTypeWObjectMemberAObjectMemberArray param =
                new ValueTypeWObjectMemberAObjectMemberArray(
                        new java.util.GregorianCalendar(), new java.util.GregorianCalendar(), 129, baseFoo,
                        simpleArray, "fooString");

	//Invoke changeComplexValueType
        ChangeComplexValueTypeResponse result1 =
                proxy.changeComplexValueType(new ChangeComplexValueType(param));

        ValueTypeWObjectMemberAObjectMemberArray result = result1.getResult();
        BaseFooObject rfoo = result.getMyValueType();
        System.out.println("\nRunning ComplexValuType from a dynamic Proxy using WSDL");
        System.out.println("Client output for testComplexValueType : " + rfoo.getFirst().toString());
        System.out.println("Client output for testComplexValueType : " + rfoo.getSecond());
        System.out.println("Client output for testComplexValueType : " + rfoo.isThird());

        System.out.println("\nOriginal unsigned long in ValueTypeWObjectMemberAObjectMemberArray : 129");
        System.out.println("Modified unsigned long in ValueTypeWObjectMemberAObjectMemberArray  : " + result.getLongUnsignedInt());

    }

    public void testSimpleIntArray()
            throws Exception {


        int[] intArray = {1, 4, 7, 9, 11};
        IntArrayTest param = new IntArrayTest(intArray);

    //Invoke reverseArray:
        ReverseArrayResponse result1 = proxy.reverseArray(new ReverseArray(param));

        IntArrayTest result = result1.getResult();
        int[] rintArray = result.getIntArray();
        System.out.println("\nRunning int[] from a dynamic Proxy client using WSDL");
        System.out.println("Client output for testSimpleIntArray   : " + java.util.Arrays.equals(intArray, rintArray));

    }
}
