/*
 * ServerHandler1.java
 */

package service;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.rpc.JAXRPCException;

import javax.xml.rpc.handler.*;
import javax.xml.soap.*;

/**
 * This class implements a handler by extending the abstract
 * class javax.xml.rpc.handler.GenericHandler.
 */
public class ServerHandler1 extends GenericHandler {
    
    private HandlerInfo handlerInfo;
    private String name;
    
    public void init(HandlerInfo info) {
        handlerInfo = info;

        // this parameter was configured in jaxrpc-ri.xml
        name = (String) info.getHandlerConfig().get("name");
        System.out.println("ServerHandler1: name = " + name);
    }
    
    /*
     * This method is declared abstract in GenericHandler and must
     * be defined here. See ServerHandler2 for another way to implement.
     */
    public QName[] getHeaders() {
        return handlerInfo.getHeaders();
    }
    
    /*
     * This handler will check incoming messages for the header
     * specified in jaxrpc-ri.xml. It doesn't do anything with the
     * information besides output it, but it could be used to determine
     * what type of processing should be performed on this message
     * before passing on to the ultimate recipient.
     */
    public boolean handleRequest(MessageContext context) {
        try {
            
            // get the soap header
            SOAPMessageContext smc = (SOAPMessageContext) context;
            SOAPMessage message = smc.getMessage();
            SOAPHeader header = message.getSOAPHeader();
            
            // check for header element matching headerElementName
            if (header != null) {
                Iterator iter = header.examineAllHeaderElements();
                while (iter.hasNext()) {
                    SOAPElement element = (SOAPElement) iter.next();
                    if (element.getElementName().getLocalName().equals("loginfo")) {

                        /*
                         * Check the loginfo element for our log level
                         * and print a message if it is important
                         * enough (over "5" in our example).
                         */
                        int logLevel = Integer.parseInt(element.getValue());
                        if (logLevel > 5) {
                            System.out.println("ServerHandler1: important " +
                                "message (level " + logLevel + ")");
                        } else {
                            // message not important enough to log
                        }
                                                
                        // remove header element per SOAP contract
                        element.detachNode();
                        
                        // stop checking after we found it
                        break;
                    }
                }
            }
            
        } catch (Exception e) {
            throw new JAXRPCException(e);
        }
        
        // return true to continue message processing
        return true;
    }
    
}
