/*
 * Copyright (c) 2002 Sun Microsystems, Inc.  All rights reserved.  U.S. 
 * Government Rights - Commercial software.  Government users are subject 
 * to the Sun Microsystems, Inc. standard license agreement and 
 * applicable provisions of the FAR and its supplements.  Use is subject 
 * to license terms.  
 * 
 * This distribution may include materials developed by third parties. 
 * Sun, Sun Microsystems, the Sun logo, Java and J2EE are trademarks 
 * or registered trademarks of Sun Microsystems, Inc. in the U.S. and 
 * other countries.  
 * 
 * Copyright (c) 2002 Sun Microsystems, Inc. Tous droits reserves.
 * 
 * Droits du gouvernement americain, utilisateurs gouvernementaux - logiciel
 * commercial. Les utilisateurs gouvernementaux sont soumis au contrat de 
 * licence standard de Sun Microsystems, Inc., ainsi qu'aux dispositions 
 * en vigueur de la FAR (Federal Acquisition Regulations) et des 
 * supplements a celles-ci.  Distribue par des licences qui en 
 * restreignent l'utilisation.
 * 
 * Cette distribution peut comprendre des composants developpes par des 
 * tierces parties. Sun, Sun Microsystems, le logo Sun, Java et J2EE 
 * sont des marques de fabrique ou des marques deposees de Sun 
 * Microsystems, Inc. aux Etats-Unis et dans d'autres pays.
 */

package database;

public class BookDetails implements Comparable {
    private String bookId = null;
    private String title = null;
    private String firstName = null;
    private String surname = null;
    private float price = 0.0F;
    private boolean onSale = false;
    private int year = 0;
    private String description = null;
    private int inventory = 0;

    public BookDetails() {

    }
    
    public BookDetails(String bookId, String surname, String firstName, String title, 
                       float price, boolean onSale, int year, String description, int inventory) {
        this.bookId = bookId;
        this.title = title;
        this.firstName =  firstName;
        this.surname = surname;
        this.price = price;
        this.onSale = onSale;
        this.year = year;
        this.description = description;
        this.inventory = inventory;
    }

    public String getBookId() {
        return this.bookId;
    }
    public String getTitle() {
        return this.title;
    }    
    public String getFirstName() {
        return this.firstName;
    }
    public String getSurname() {
        return this.surname;
    }
    public float getPrice() {
       return this.price;
    }
    public boolean getOnSale() {
       return this.onSale;
    }
    public int getYear() {
        return this.year;
    }
    public String getDescription() {
        return this.description;
    }
    public int getInventory() {
        return this.inventory;
    }
    public void setBookId(String id) {
        this.bookId=id;
    }
    public void setTitle(String title) {
        this.title=title;
    }
    public void setFirstName(String firstName) {
        this.firstName=firstName;
    }
    public void setSurname(String surname) {
        this.surname=surname;
    }
    public void setPrice(float price) {
       this.price = price;
    }
    public void setOnSale(boolean onSale) {
       this.onSale = onSale;
    }
    public void setYear(int year) {
        this.year = year;
    }   
    public void setDescription(String description) {
        this.description=description;
    }   
    public void setInventory(int inventory) {
        this.inventory=inventory;
    }
    public int compareTo(Object o) {
         BookDetails n = (BookDetails)o;
         int lastCmp = title.compareTo(n.title);
            return (lastCmp);
    }   
}

