/*
 * Copyright (c) 2002 Sun Microsystems, Inc.  All rights reserved.  U.S. 
 * Government Rights - Commercial software.  Government users are subject 
 * to the Sun Microsystems, Inc. standard license agreement and 
 * applicable provisions of the FAR and its supplements.  Use is subject 
 * to license terms.  
 * 
 * This distribution may include materials developed by third parties. 
 * Sun, Sun Microsystems, the Sun logo, Java and J2EE are trademarks 
 * or registered trademarks of Sun Microsystems, Inc. in the U.S. and 
 * other countries.  
 * 
 * Copyright (c) 2002 Sun Microsystems, Inc. Tous droits reserves.
 * 
 * Droits du gouvernement americain, utilisateurs gouvernementaux - logiciel
 * commercial. Les utilisateurs gouvernementaux sont soumis au contrat de 
 * licence standard de Sun Microsystems, Inc., ainsi qu'aux dispositions 
 * en vigueur de la FAR (Federal Acquisition Regulations) et des 
 * supplements a celles-ci.  Distribue par des licences qui en 
 * restreignent l'utilisation.
 * 
 * Cette distribution peut comprendre des composants developpes par des 
 * tierces parties. Sun, Sun Microsystems, le logo Sun, Java et J2EE 
 * sont des marques de fabrique ou des marques deposees de Sun 
 * Microsystems, Inc. aux Etats-Unis et dans d'autres pays.
 * 
 */

package listeners;

import database.BookDB;
import javax.servlet.*;
import util.Counter;

public final class ContextListener
    implements ServletContextListener {
    private ServletContext context = null;

    public void contextInitialized(ServletContextEvent event) {
         context = event.getServletContext();
         
         try {
            BookDB bookDB = new BookDB();
            context.setAttribute("bookDB", bookDB);
         } catch (Exception ex) {
            System.out.println("Couldn't create bookstore database bean: " + ex.getMessage());
         }

         Counter counter = new Counter();
         context.setAttribute("hitCounter", counter);
         counter = new Counter();
         context.setAttribute("orderCounter", counter);
    }
      
    public void contextDestroyed(ServletContextEvent event) {
         context = event.getServletContext();
         BookDB bookDB = (BookDB)context.getAttribute("bookDB");
         if (bookDB != null)
         	bookDB.remove();
         context.removeAttribute("bookDB");
         context.removeAttribute("hitCounter");
         context.removeAttribute("orderCounter");
    }
}
