/*
 * ServerHandler2.java
 */

package service;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.rpc.JAXRPCException;

import javax.xml.rpc.handler.*;
import javax.xml.soap.*;

/**
 * This class implements a handler by extending the abstract
 * class javax.xml.rpc.handler.GenericHandler.
 */
public class ServerHandler2 extends GenericHandler {
    
    private QName [] qnames;
    private String name;
    
    public void init(HandlerInfo info) {
        qnames = info.getHeaders();

        // this parameter was configured in jaxrpc-ri.xml
        name = (String) info.getHandlerConfig().get("name");
        System.out.println("ServerHandler2: name = " + name);
    }
    
    /*
     * This method is declared abstract in GenericHandler and must
     * be defined here. See ServerHandler2 for another way to implement.
     */
    public QName[] getHeaders() {
        return qnames;
    }
    
    /*
     * 
     */
    public boolean handleRequest(MessageContext context) {
        try {
            
            // get the soap header
            SOAPMessageContext smc = (SOAPMessageContext) context;
            SOAPMessage message = smc.getMessage();
            SOAPHeader header = message.getSOAPHeader();
            
            // check for header element matching headerElementName
            if (header != null) {
                Iterator iter = header.examineAllHeaderElements();
                while (iter.hasNext()) {
                    SOAPElement element = (SOAPElement) iter.next();
                    if (element.getElementName().getLocalName().equals("clientname")) {
                        
                        /* Do not need to remove this element because we
                         * did not declare that it was one that we understood.
                         * Simply examining the element here. If mustUnderstand
                         * equalled 1 for this element, a fault would be
                         * produced.
                         */
                        String clientName = element.getValue();
                        System.out.println("ServerHandler2: Request is from " +
                            clientName);
                    }
                }
            }
            
        } catch (Exception e) {
            throw new JAXRPCException(e);
        }

        // return true to continue message processing
        return true;
    }
    
}
