package hello;  
                 
import java.math.*;

public class HelloClient 
{      

    HelloIF_Stub stub = null;
    HelloOneWayIF_Stub onewayStub = null;
    ValueType valueType = null;

    public static void main(String[] args) 
    {    
        try {
            HelloClient client =  new HelloClient();
            client.testEchoString(); 
            client.testValueType();
            client.testComplexValueType();
            client.testSimpleIntArray();
        } catch (Exception ex) {        
            ex.printStackTrace();       
        }       
    }   

    public HelloClient()
    {
        try {   
            stub = (HelloIF_Stub)  
            (new HelloWorldService_Impl().getHelloIFPort());   
            onewayStub = (HelloOneWayIF_Stub)  
            (new HelloWorldOneWayService_Impl().getHelloOneWayIFPort());   
            valueType = new ValueType(true,new Integer(23),"Test Data");
        } catch (Exception ex) {        
            ex.printStackTrace();       
        }       
    }

    public void testEchoString()
    throws Exception
    {
        System.out.println("Running echo String from a staticstub client."); 
        System.out.println(stub.sayHello(new SayHello("Hi there ", "Duke!!!")).getResult()); 
    }

    public void testValueType()
    throws Exception
    {
        System.out.println("\nRunning SimpleValueType from a staticstub client."); 
        ValueType vt = stub.changeValueType(new ChangeValueType(valueType)).getResult();
        System.out.println("Echoing the boolean set in ValueType by server :" + vt.isBoolProperty());
        System.out.println("Echoing the integer set in ValueType by server :" 
        + vt.getIntegerProperty().intValue());
        System.out.println("Echoing the string set in ValueType by server  :" + vt.getStringProperty());

        System.out.println("\nRunning the one way operation using ValuType from a staticstub client ");
        onewayStub.oneWayValueType(new OneWayValueType(valueType));

    }

    public void testComplexValueType() 
    throws Exception 
    {
        BaseFooObject baseFoo = new BaseFooObject(new BigInteger("12345"), 04, true);
        int[] intArray = {1,4,7,9,11};
        IntArrayTest simpleArray = new IntArrayTest(intArray);

        ValueTypeWObjectMemberAObjectMemberArray param = 
           new ValueTypeWObjectMemberAObjectMemberArray(
           new java.util.GregorianCalendar(), new java.util.GregorianCalendar(), 129, baseFoo, 
           simpleArray, "fooString");


        ChangeComplexValueTypeResponse result1 = 
        stub.changeComplexValueType(new ChangeComplexValueType(param));
        ValueTypeWObjectMemberAObjectMemberArray result = result1.getResult();
        BaseFooObject rfoo = result.getMyValueType();
        System.out.println("\nRunning ComplexValuType from a staticstub client ");
        System.out.println("Client output for testComplexValueType : " + rfoo.getFirst().toString()); 
        System.out.println("Client output for testComplexValueType : " + rfoo.getSecond()); 
        System.out.println("Client output for testComplexValueType : " + rfoo.isThird()); 

        System.out.println("\nOriginal unsigned long in ValueTypeWObjectMemberAObjectMemberArray : 129");
        System.out.println("Modified unsigned long in ValueTypeWObjectMemberAObjectMemberArray  : " 
        + result.getLongUnsignedInt()); 
    }

    public void testSimpleIntArray() 
    throws Exception 
    {
        int[] intArray = {1,4,7,9,11};
        IntArrayTest param = new IntArrayTest(intArray);
        ReverseArrayResponse result1 = stub.reverseArray(new ReverseArray(param));
        IntArrayTest result = result1.getResult(); 
        int[] rintArray = result.getIntArray();
        System.out.println("\nRunning int[] from a staticstub client ");
        System.out.println("Client output for testSimpleIntArray   : " +  java.util.Arrays.equals(intArray, rintArray));
    }
}
