/*
This file is licensed under the terms of the Globus Toolkit Public
License, found at http://www.globus.org/toolkit/download/license.html.
*/
package org.globus.progtutorial.clients.GridService;

import org.gridforum.ogsi.OGSIServiceGridLocator;
import org.gridforum.ogsi.GridService;
import org.gridforum.ogsi.ExtensibilityType;
import org.gridforum.ogsi.HandleType;
import org.gridforum.ogsi.ServiceDataValuesType;
import org.gridforum.ogsi.LocatorType;
import org.gridforum.ogsi.TerminationTimeType;
import org.gridforum.ogsi.ExtendedDateTimeType;
import org.globus.ogsa.utils.AnyHelper;
import org.globus.ogsa.utils.QueryHelper;
import java.net.URL;
import javax.xml.namespace.QName;

public class PrintGridServiceData
{
	public static void main(String[] args)
	{
		try
		{
			// Get command-line arguments
			URL GSH = new java.net.URL(args[0]);

			// Get a reference to the GridService portType
			OGSIServiceGridLocator locator = new OGSIServiceGridLocator();
			GridService gridService = locator.getGridServicePort(GSH);

			// gridServiceHandle
			// GSH of this instance (can have more than one)
			ExtensibilityType extensibility = gridService.findServiceData(QueryHelper.getNamesQuery("gridServiceHandle"));
			ServiceDataValuesType serviceData = AnyHelper.getAsServiceDataValues(extensibility);
			Object[] gridServiceHandles = AnyHelper.getAsObject(serviceData);
			for(int i=0; i<gridServiceHandles.length; i++)
			{
				HandleType gridServiceHandle = (HandleType) gridServiceHandles[i];
				System.out.println("gridServiceHandle: " + gridServiceHandle);
			}


			// factoryLocator
			// Locator for the factory that created this instance
			extensibility = gridService.findServiceData(QueryHelper.getNamesQuery("factoryLocator"));
			serviceData = AnyHelper.getAsServiceDataValues(extensibility);
			if (serviceData.get_any() == null)
				System.out.println("factoryLocator: Not created by a factory!");
			else
			{
				Object[] factoryLocators = AnyHelper.getAsObject(serviceData);
				for(int i=0; i<factoryLocators.length; i++)
				{
					LocatorType factoryLocator = (LocatorType) factoryLocators[i];
					System.out.println("factoryLocator: " + factoryLocator.getHandle(0));
				}
			}


			// terminationTime
			// The termination time for this service
			extensibility = gridService.findServiceData(QueryHelper.getNamesQuery("terminationTime"));
			serviceData = AnyHelper.getAsServiceDataValues(extensibility);
			TerminationTimeType terminationTime = (TerminationTimeType) AnyHelper.getAsSingleObject(serviceData);
			ExtendedDateTimeType after, before;
			after = terminationTime.getAfter();
			before = terminationTime.getBefore();

			if (after.getInfinityTypeValue().getValue().equals("infinity"))
				System.out.println("terminationTime (after): The service plans to exist indefinitely");
			else if (after.getDateTimeValue().before(terminationTime.getTimestamp().getTime()))
				System.out.println("terminationTime (after): May terminate at any time.");
			else
				System.out.println("terminationTime (after): " + after.getDateTimeValue().getTime());

			if (before.getInfinityTypeValue().getValue().equals("infinity"))
				System.out.println("terminationTime (before): The service has no plans to terminate.");
			else if (before.getDateTimeValue().before(terminationTime.getTimestamp().getTime()))
				System.out.println("terminationTime (before): The service is trying to terminate.");
			else
				System.out.println("terminationTime (before): " + before.getDateTimeValue().getTime());

			System.out.println("terminationTime (timestamp): " + terminationTime.getTimestamp().getTime());



			// serviceDataNames
			// Names of Service Data offered by this Grid Service
			extensibility = gridService.findServiceData(QueryHelper.getNamesQuery("serviceDataName"));
			serviceData = AnyHelper.getAsServiceDataValues(extensibility);
			Object[] serviceDataNames = AnyHelper.getAsObject(serviceData);
			for(int i=0; i<serviceDataNames.length; i++)
			{
				QName serviceDataName = (QName) serviceDataNames[i];
				System.out.println("serviceDataName: " + serviceDataName);
			}


			// interfaces
			// Names of interfaces exposed by this Grid Service
			extensibility = gridService.findServiceData(QueryHelper.getNamesQuery("interface"));
			serviceData = AnyHelper.getAsServiceDataValues(extensibility);
			Object[] interfaces = AnyHelper.getAsObject(serviceData);
			for(int i=0; i<interfaces.length; i++)
			{
				QName iface = (QName) interfaces[i];
				System.out.println("interface: " + iface);
			}

		}catch(Exception e)
		{
			System.out.println("ERROR!");
			e.printStackTrace();
		}
	}
}
