/*
This file is licensed under the terms of the Globus Toolkit Public
License, found at http://www.globus.org/toolkit/download/license.html.
*/
package org.globus.progtutorial.clients.MathService_sd;

import org.gridforum.ogsi.ExtensibilityType;
import org.gridforum.ogsi.ServiceDataValuesType;
import org.globus.ogsa.utils.AnyHelper;
import org.globus.ogsa.utils.QueryHelper;

import org.globus.progtutorial.stubs.MathService_sd.service.MathServiceGridLocator;
import org.globus.progtutorial.stubs.MathService_sd.MathPortType;
import org.globus.progtutorial.stubs.MathService_sd.servicedata.MathDataType;
import java.net.URL;

public class Client
{
	public static void main(String[] args)
	{
		try
		{
			// Get command-line arguments
			URL GSH = new java.net.URL(args[0]);
			int a = Integer.parseInt(args[1]);

			// Get a reference to the Math PortType
			MathServiceGridLocator mathServiceLocator = new MathServiceGridLocator();
			MathPortType math = mathServiceLocator.getMathServicePort(GSH);

			// Get Service Data Element "MathData"
			ExtensibilityType extensibility = math.findServiceData(QueryHelper.getNamesQuery("MathData"));
			ServiceDataValuesType serviceData = AnyHelper.getAsServiceDataValues(extensibility);
			MathDataType mathData = (MathDataType) AnyHelper.getAsSingleObject(serviceData, MathDataType.class);

			// Write service data
			System.out.println("Value: " + mathData.getValue());
			System.out.println("Previous operation: " + mathData.getLastOp());
			System.out.println("# of operations: " + mathData.getNumOps());

			// Call remote method
			math.add(a);
		}catch(Exception e)
		{
			System.out.println("ERROR!");
			e.printStackTrace();
		}
	}
}
