/*
This file is licensed under the terms of the Globus Toolkit Public
License, found at http://www.globus.org/toolkit/download/license.html.
*/
package org.globus.progtutorial.services.core.lifecycle.impl;

import org.globus.ogsa.GridServiceBase;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.GridContext;
import org.globus.ogsa.GridServiceCallback;
import org.globus.ogsa.impl.ogsi.PersistentGridServiceImpl;

import org.globus.progtutorial.stubs.MathService.MathPortType;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.rmi.RemoteException;

public class MathImpl extends PersistentGridServiceImpl implements MathPortType, GridServiceCallback
{
	// Create this class's logger
	static Log logger = LogFactory.getLog(MathImpl.class.getName());

	private int value = 0;

	public void add(int a) throws RemoteException
	{
		logger.info("Addition invoked with parameter a=" + String.valueOf(a));
		if (a==0)
			logger.warn("Adding zero doesn't modify the internal value!");
		value = value + a;
	}

	public void subtract(int a) throws RemoteException
	{
		logger.info("Addition invoked with parameter a=" + String.valueOf(a));
		if (a==0)
			logger.warn("Subtracting zero doesn't modify the internal value!");
		value = value - a;
	}

	public int getValue() throws RemoteException
	{
		logger.info("getValue() invoked");
		return value;
	}

	// Callback methods
	public void preCreate(GridServiceBase base) throws GridServiceException
	{
		super.preCreate(base);
		logger.info("Instance is going to be created (preCreate)");
	}

	public void postCreate(GridContext context) throws GridServiceException
	{
		super.postCreate(context);
		logger.info("Instance has been created (postCreate)");
	}

	public void activate(GridContext context) throws GridServiceException
	{
		super.activate(context);
		logger.info("Instance has been activated (activate)");
	}

	public void deactivate(GridContext context) throws GridServiceException
	{
		super.deactivate(context);
		logger.info("Instance has been deactivated (deactivate)");
	}

	public void preDestroy(GridContext context) throws GridServiceException
	{
		super.preDestroy(context);
		logger.info("Instance is going to be destroyed (preDestroy)");
	}
}
