/*
This file is licensed under the terms of the Globus Toolkit Public
License, found at http://www.globus.org/toolkit/download/license.html.
*/
package org.globus.progtutorial.services.core.lifecycle.impl;

import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.ServiceLifecycleMonitor;
import org.globus.ogsa.GridContext;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MathLifecycleMonitor implements ServiceLifecycleMonitor
{
	// Create this class's logger
	static Log logger = LogFactory.getLog(MathLifecycleMonitor.class.getName());

	public void create(GridContext context) throws GridServiceException
	{
		logger.info("Instance is going to be created (create)");
	}

	public void destroy(GridContext context) throws GridServiceException
	{
		logger.info("Instance is going to be destroyed (destroy)");
	}

	public void preCall(GridContext context) throws GridServiceException
	{
		logger.info("Service is going to be invoked (preCall)");
	}

	public void postCall(GridContext context) throws GridServiceException
	{
		logger.info("Service invocation has finished  (postCall)");
	}

	public void preSerializationCall(GridContext context)
	{
		logger.info("Input parameters are going to be deserialized (preSerializationCall)");
	}

	public void postSerializationCall(GridContext context)
	{
		logger.info("Input parameters have been deserialized (postSerializationCall)");
	}
}
