/*
This file is licensed under the terms of the Globus Toolkit Public
License, found at http://www.globus.org/toolkit/download/license.html.
*/
package org.globus.progtutorial.services.core.logging.impl;

import org.globus.ogsa.impl.ogsi.PersistentGridServiceImpl;
import org.globus.progtutorial.stubs.MathService.MathPortType;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.rmi.RemoteException;

public class MathImpl extends PersistentGridServiceImpl implements MathPortType
{
	// Create this class's logger
	static Log logger = LogFactory.getLog(MathImpl.class.getName());

	private int value = 0;

	public void add(int a) throws RemoteException
	{
		logger.info("Addition invoked with parameter a=" + String.valueOf(a));
		if (a==0)
			logger.warn("Adding zero doesn't modify the internal value!");
		value = value + a;
	}

	public void subtract(int a) throws RemoteException
	{
		logger.info("Addition invoked with parameter a=" + String.valueOf(a));
		if (a==0)
			logger.warn("Subtracting zero doesn't modify the internal value!");
		value = value - a;
	}

	public int getValue() throws RemoteException
	{
		logger.info("getValue() invoked");
		return value;
	}
}
