/*
This file is licensed under the terms of the Globus Toolkit Public
License, found at http://www.globus.org/toolkit/download/license.html.
*/
package org.globus.progtutorial.services.core.providers.impl;

import org.globus.ogsa.GridServiceBase;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.OperationProvider;

import java.rmi.RemoteException;
import javax.xml.namespace.QName;

public class MathProvider implements OperationProvider
{
	// Operation provider properties
	private static final String namespace = "http://www.globus.org/namespaces/2004/02/progtutorial/MathService";
	
	private static final QName[] operations = 
		new QName[]
			{
			new QName(namespace, "add"),
			new QName(namespace, "subtract"),
			new QName(namespace, "getValue")
			};
	
	private GridServiceBase base;

	// Operation Provider methods
	public void initialize(GridServiceBase base) throws GridServiceException
	{
		this.base = base;
	}

	public QName[] getOperations()
	{
		return operations;
	}


	private int value = 0;

	public void add(int a) throws RemoteException
	{
		value = value + a;
	}

	public void subtract(int a) throws RemoteException
	{
		value = value - a;
	}

	public int getValue() throws RemoteException
	{
		return value;
	}
}
