/*
This file is licensed under the terms of the Globus Toolkit Public
License, found at http://www.globus.org/toolkit/download/license.html.
*/
package org.globus.progtutorial.clients.MathService;

import org.globus.progtutorial.stubs.MathService.service.MathServiceGridLocator;
import org.globus.progtutorial.stubs.MathService.MathPortType;

import org.globus.ogsa.impl.security.Constants;
import org.globus.ogsa.impl.security.authorization.NoAuthorization;

import javax.xml.rpc.Stub;
import java.net.URL;

public class ClientGSIConvEncrypt
{
	public static void main(String[] args)
	{
		try
		{
			// Get command-line arguments
			URL GSH = new java.net.URL(args[0]);
			int a = Integer.parseInt(args[1]);

			// Get a reference to the MathService instance
			MathServiceGridLocator mathLocator =   new MathServiceGridLocator();
			MathPortType math = mathLocator.getMathServicePort(GSH);

			// Setup security options
			((Stub)math)._setProperty(Constants.GSI_SEC_CONV,Constants.ENCRYPTION);
			((Stub)math)._setProperty(Constants.AUTHORIZATION,NoAuthorization.getInstance());
                     	((Stub)math)._setProperty(Constants.GRIM_POLICY_HANDLER,new  org.globus.gsi.proxy.IgnoreProxyPolicyHandler());
			// Call remote method 'add'
			try{
				math.add(a);
				System.out.println("Added " + a);
			} catch(Exception e)
			{
				System.out.println("ERROR: " + e.getMessage());
			}

			// Call remote method 'subtract'
			try{
				math.subtract(1);
				System.out.println("Subtracted 1");
			} catch(Exception e)
			{
				System.out.println("ERROR: " + e.getMessage());
			}

			// Get current value through remote method 'getValue'
			try{
				int value = math.getValue();
				System.out.println("Current value: " + value);
			} catch(Exception e)
			{
				System.out.println("ERROR: " + e.getMessage());
			}
		}catch(Exception e)
		{
			System.out.println("ERROR!");
			e.printStackTrace();
		}
	}
}
