/*
This file is licensed under the terms of the Globus Toolkit Public
License, found at http://www.globus.org/toolkit/download/license.html.
*/
package org.globus.progtutorial.clients.MathService;

import org.gridforum.ogsi.OGSIServiceGridLocator;
import org.gridforum.ogsi.Factory;
import org.gridforum.ogsi.LocatorType;
import org.globus.ogsa.utils.GridServiceFactory;

import org.globus.progtutorial.stubs.MathService.service.MathServiceGridLocator;
import org.globus.progtutorial.stubs.MathService.MathPortType;

import java.net.URL;

public class FactoryClient
{
	public static void main(String[] args)
	{
		try
		{
			// Get command-line arguments
			URL GSH = new java.net.URL(args[0]);
			int a = Integer.parseInt(args[1]);

			// Get a reference to the MathService Factory
			OGSIServiceGridLocator gridLocator = new OGSIServiceGridLocator();
			Factory factory = gridLocator.getFactoryPort(GSH);
			GridServiceFactory mathFactory = new GridServiceFactory(factory);

			// Create a new MathService instance and get a reference
			// to its Math PortType
			LocatorType locator = mathFactory.createService();
			MathServiceGridLocator mathLocator =   new MathServiceGridLocator();
			MathPortType math = mathLocator.getMathServicePort(locator);

			// Call remote method 'add'
			math.add(a);
			System.out.println("Added " + a);

			// Get current value through remote method 'getValue'
			int value = math.getValue();
			System.out.println("Current value: " + value);

			// Destroy the instance
			math.destroy();
		}catch(Exception e)
		{
			System.out.println("ERROR!");
			e.printStackTrace();
		}
	}
}
