/*
This file is licensed under the terms of the Globus Toolkit Public
License, found at http://www.globus.org/toolkit/download/license.html.
*/
package org.globus.progtutorial.clients.MathService_sd_notif;

import org.globus.ogsa.client.managers.NotificationSinkManager;
import org.globus.ogsa.NotificationSinkCallback;
import org.globus.ogsa.impl.core.service.ServicePropertiesImpl;
import org.globus.ogsa.utils.AnyHelper;
import org.gridforum.ogsi.ExtensibilityType;
import org.gridforum.ogsi.HandleType;
import org.gridforum.ogsi.ServiceDataValuesType;

import org.globus.progtutorial.stubs.MathService_sd_notif.servicedata.MathDataType;

import java.rmi.RemoteException;

public class ClientListener extends ServicePropertiesImpl implements NotificationSinkCallback
{
	public static void main(String[] args)
	{
		try
		{
			// Get command-line arguments
			HandleType GSH = new HandleType(args[0]);
			ClientListener clientListener = new ClientListener(GSH);
		}catch(Exception e)
		{
			System.out.println("ERROR!");
			e.printStackTrace();
		}
	}

	public ClientListener(HandleType GSH) throws Exception
	{
		// Start listening to the MathService
		NotificationSinkManager notifManager = NotificationSinkManager.getManager();
		notifManager.startListening(NotificationSinkManager.MAIN_THREAD);
		String sink  =  notifManager.addListener("MathData", null, GSH, this);
		System.out.println("Listening...");

		// Wait for key press
		System.in.read();

		// Stop listening
		notifManager.removeListener(sink);
		notifManager.stopListening();
		System.out.println("Not listening anymore!");
    }

	public void deliverNotification(ExtensibilityType any) throws RemoteException
	{
		try
		{
			// Service Data has changed. Show new data.
			ServiceDataValuesType serviceData = AnyHelper.getAsServiceDataValues(any);
			MathDataType mathData = (MathDataType) AnyHelper.getAsSingleObject(serviceData, MathDataType.class);

			// Write service data
			System.out.println("Current value: " + mathData.getValue());
			System.out.println("Previous operation: " + mathData.getLastOp());
			System.out.println("# of operations: " + mathData.getNumOps());
		}catch(Exception exc)
		{
			System.out.println("ERROR!");
			exc.printStackTrace();
		}
	}
}
