/*
This file is licensed under the terms of the Globus Toolkit Public
License, found at http://www.globus.org/toolkit/download/license.html.
*/
package org.globus.progtutorial.services.core.notifications.impl;

import org.globus.ogsa.ServiceData;
import org.globus.ogsa.impl.ogsi.PersistentGridServiceImpl;
import org.globus.ogsa.GridContext;
import org.globus.ogsa.GridServiceException;
import org.globus.progtutorial.stubs.MathService_sd_notif.servicedata.MathDataType;
import java.rmi.RemoteException;

public class MathImpl extends PersistentGridServiceImpl
{
	private ServiceData mathDataSDE;
	private MathDataType mathDataValue;

	public MathImpl()
	{
		super("Simple MathService with Notifications");
	}

	public void postCreate(GridContext context) throws GridServiceException
	{
		super.postCreate(context);

		// Create Service Data Element
		mathDataSDE = this.getServiceDataSet().create("MathData");

		// Create a MathDataType instance and set intial values
		mathDataValue = new MathDataType();
		mathDataValue.setLastOp("NONE");
		mathDataValue.setNumOps(0);
		mathDataValue.setValue(0);
				
		// Set the value of the SDE to the MathDataType instance
		mathDataSDE.setValue(mathDataValue);

		// Add SDE to Service Data Set
		this.getServiceDataSet().add(mathDataSDE);
	}


	// This method updates the MathData SDE increasing the
	// number of operations by one
	private void incrementOps()
	{
		int numOps = mathDataValue.getNumOps();
		mathDataValue.setNumOps(numOps + 1);
	}

	public void add(int a) throws RemoteException
	{
		mathDataValue.setLastOp("Addition");
		incrementOps();
		mathDataValue.setValue(mathDataValue.getValue() + a);
		mathDataSDE.notifyChange();
	}

	public void subtract(int a) throws RemoteException
	{
		mathDataValue.setLastOp("Subtraction");
		incrementOps();
		mathDataValue.setValue(mathDataValue.getValue() - a);
		mathDataSDE.notifyChange();
	}

}
