/*
This file is licensed under the terms of the Globus Toolkit Public
License, found at http://www.globus.org/toolkit/download/license.html.
*/
package org.globus.progtutorial.clients.MathService;

import org.globus.progtutorial.stubs.MathService.service.MathServiceGridLocator;
import org.globus.progtutorial.stubs.MathService.MathPortType;

import java.net.URL;

public class Client
{
	public static void main(String[] args)
	{
		try
		{
			// Get command-line arguments
			URL GSH = new java.net.URL(args[0]);
			int a = Integer.parseInt(args[1]);

			// Get a reference to the MathService instance
			MathServiceGridLocator mathServiceLocator = new MathServiceGridLocator();
			MathPortType math = mathServiceLocator.getMathServicePort(GSH);

			// Call remote method 'add'
			math.add(a);
			System.out.println("Added " + a);

			// Get current value through remote method 'getValue'
			int value = math.getValue();
			System.out.println("Current value: " + value);
		}catch(Exception e)
		{
			System.out.println("ERROR!");
			e.printStackTrace();
		}
	}
}
