/*
This file is licensed under the terms of the Globus Toolkit Public
License, found at http://www.globus.org/toolkit/download/license.html.
*/
package org.globus.progtutorial.services.core.first.impl;

import org.globus.ogsa.impl.ogsi.PersistentGridServiceImpl;
import org.globus.progtutorial.stubs.MathService.MathPortType;
import java.rmi.RemoteException;

public class MathImpl extends PersistentGridServiceImpl implements MathPortType
{
	private int value = 0;

	public MathImpl()
	{
		super("Simple MathService");
	}

	public void add(int a) throws RemoteException
	{
		value = value + a;
	}

	public void subtract(int a) throws RemoteException
	{
		value = value - a;
	}

	public int getValue() throws RemoteException
	{
		return value;
	}
}
