import java.awt.*;
import java.awt.event.*;
import java.util.*;

class BasicShape implements Shape {
	protected String name;
	protected int x, y;

	public BasicShape(String n) {
		name = n;
	}

	public void placeAt(int x0, int y0) {
		x = x0;
		y = y0;
	}

	public void drawIt(Graphics g) {
		FontMetrics fontM = g.getFontMetrics();
		int newx, newy;
		g.setColor(Color.cyan);
		newx = x - fontM.stringWidth(name) / 2;
		newy = y - fontM.getHeight() / 2;
		g.drawString(name, newx, newy + fontM.getAscent());
	}

	public void drawLink(Graphics g, Shape e2) {
		g.setColor(Color.green);
		g.drawLine(x, y, e2.getX(), e2.getY());
	}

	public boolean isIn(int x0, int y0) {
		return false;
	}

	public int getX() {
		return x;
	}

	public int getY() {
		return y;
	}
}

// *************************************************
//
// Students need to program for it
// *************************************************

class floatType extends Type {
	public floatType(String n) {
		super(n);
		shape = new RoundRect(n);
	}

	public String buildCode() {
		return "  float " + name + ";\n";
	}
}

// *************************************************
// To show the Help dialog.
// You can put your own "msg" here
// *************************************************

class HelpDialog extends Dialog implements ActionListener {
	String msg = "   Sorry, no help, you have to do this project on your own!\n"
			+ "   \n"
			+ "   To create a type, just click on the \"New Type\" button,\n"
			+ "   and fill out the dialog box.\n"
			+ "   If you want to create a field of a structured type, select\n"
			+ "   UserDefined Type and give the name of the field as well as\n"
			+ "   the name of the type.\n"
			+ "   \n"
			+ "   The drawing of the tree is not ideal by any means!";

	HelpDialog(Frame f) {
		super(f, "Message", true);

		Button b = new Button("OK");
		TextArea msgArea = new TextArea(msg);

		b.addActionListener(this);
		addWindowListener(new WindowEventHandler());

		add(msgArea, BorderLayout.NORTH);
		add(b, BorderLayout.SOUTH);

		pack();
		Dimension myDim = getSize();
		Dimension frameDim = f.getSize();
		Dimension screenSize = getToolkit().getScreenSize();
		Point loc = f.getLocation();

		loc.translate((frameDim.width - myDim.width) / 2,
				(frameDim.height - myDim.height) / 2);

		loc.x = Math
				.max(0, Math.min(loc.x, screenSize.width - getSize().width));
		loc.y = Math.max(0,
				Math.min(loc.y, screenSize.width - getSize().height));

		setLocation(loc.x, loc.y);
		show();
	}

	public void actionPerformed(ActionEvent evt) {
		dispose();
	}

	class WindowEventHandler extends WindowAdapter {
		public void windowClosing(WindowEvent evt) {
			dispose();
		}
	}
}

// *************************************************
// For drawing dialog.
// DO NOT change anything here
// *************************************************

class InsertDialog extends Dialog implements ActionListener, ItemListener {
	ButtonListener buttonListener = new ButtonListener();
	Button IDOK, IDCANCEL;
	VisualType m_Parent;
	Choice IDC_COMBO_TYPE;
	TextField IDC_EDIT_NAME;
	Label IDC_STATIC1;
	Label IDC_STATIC2;
	Label IDC_STATIC3;
	TextField IDC_EDIT_CLASSNAME;
	userDefType e;

	InsertDialog(Frame f, userDefType e0) {
		super(f, "Insert", true);
		m_Parent = (VisualType) f;
		e = e0;

		IDOK = new Button("OK");
		IDOK.addActionListener(buttonListener);
		IDCANCEL = new Button("CANCEL");
		IDCANCEL.addActionListener(buttonListener);

		f.setLayout(new GridBagLayout());
		IDC_STATIC1 = new Label("Type:");
		IDC_COMBO_TYPE = new Choice();
		IDC_COMBO_TYPE.addItemListener(this);
		IDC_COMBO_TYPE.add("int");
		IDC_COMBO_TYPE.add("float");
		IDC_COMBO_TYPE.add("String");
		IDC_COMBO_TYPE.add("user defined");
		IDC_STATIC2 = new Label("Name:");
		IDC_STATIC3 = new Label("Class Name:");
		IDC_EDIT_NAME = new TextField("");
		IDC_STATIC3.setEnabled(false);
		IDC_EDIT_CLASSNAME = new TextField("");
		IDC_EDIT_CLASSNAME.setEnabled(false);

		Panel p1 = new Panel(new GridLayout(3, 2));
		p1.add(IDC_STATIC1);
		p1.add(IDC_COMBO_TYPE);
		p1.add(IDC_STATIC2);
		p1.add(IDC_EDIT_NAME);
		p1.add(IDC_STATIC3);
		p1.add(IDC_EDIT_CLASSNAME);

		Panel p2 = new Panel(new GridLayout(1, 0));
		p2.add(IDOK);
		p2.add(IDCANCEL);

		addWindowListener(new WindowEventHandler());

		add(p1, BorderLayout.NORTH);
		add(p2, BorderLayout.SOUTH);

		pack();
		Dimension myDim = getSize();
		Dimension frameDim = f.getSize();
		Dimension screenSize = getToolkit().getScreenSize();
		Point loc = f.getLocation();

		loc.translate((frameDim.width - myDim.width) / 2,
				(frameDim.height - myDim.height) / 2);

		loc.x = Math
				.max(0, Math.min(loc.x, screenSize.width - getSize().width));
		loc.y = Math.max(0,
				Math.min(loc.y, screenSize.width - getSize().height));

		setLocation(loc.x, loc.y);
		show();
	}

	public void actionPerformed(ActionEvent evt) {
		dispose();
	}

	class WindowEventHandler extends WindowAdapter {
		public void windowClosing(WindowEvent evt) {
			dispose();
		}
	}

	public void itemStateChanged(ItemEvent e) {
		Object ib = e.getSource();
		String s = ((Choice) ib).getSelectedItem();
		if (s.equals("user defined")) {
			IDC_STATIC3.setEnabled(true);
			IDC_EDIT_CLASSNAME.setEnabled(true);
		} else {
			IDC_STATIC3.setEnabled(false);
			IDC_EDIT_CLASSNAME.setEnabled(false);
		}
	}

	class ButtonListener implements ActionListener {
		public void actionPerformed(ActionEvent event) {
			Object ib = event.getSource();
			if (ib == IDCANCEL)
				dispose();
			else if (ib == IDOK) {
				Type ne;
				String val = IDC_EDIT_NAME.getText();
				String typename = IDC_EDIT_CLASSNAME.getText();
				String type = IDC_COMBO_TYPE.getSelectedItem();
				if (val.equals(""))
					System.out.println("must have name!");
				else if ((type.equals("user defined")) && typename.equals(""))
					System.out.println("must have typename!");
				else {
					if (type.equals("int"))
						ne = new intType(val);
					else if (type.equals("String"))
						ne = new stringType(val);
					else if (type.equals("float"))
						ne = new floatType(val);
					else
						ne = new userDefType(val, typename);
					e.insert(ne);
					m_Parent.outputPanel.repaint();
					m_Parent.outputPanel.validate();
				}
				dispose();
			}
		}
	}

}

// *************************************************
//
// Students need to program for it
// *************************************************

class intType extends Type {
	public intType(String n) {
		super(n);
		shape = new Rect(n);
	}

	public String buildCode() {
		return "  int " + name + ";\n";
	}
}

// *************************************************
// For drawing dialog.
// DO NOT change anything here
// *************************************************

class NewDialog extends Dialog implements ActionListener {
	NewdlgButtonListener newdlgButtonListener = new NewdlgButtonListener();
	Button IDOK, IDCANCEL;
	VisualType m_Parent;
	TextField name;

	NewDialog(Frame f) {
		super(f, "Message", true);
		m_Parent = (VisualType) f;

		IDOK = new Button("OK");
		IDOK.addActionListener(newdlgButtonListener);
		IDCANCEL = new Button("CANCEL");
		IDCANCEL.addActionListener(newdlgButtonListener);

		f.setLayout(new GridBagLayout());
		Label l = new Label("New class's name:");
		name = new TextField("", 15);

		Panel p1 = new Panel(new GridLayout(1, 0));
		p1.add(l);
		p1.add(name);

		Panel p2 = new Panel(new GridLayout(1, 0));
		p2.add(IDOK);
		p2.add(IDCANCEL);

		addWindowListener(new WindowEventHandler());

		add(p1, BorderLayout.NORTH);
		add(p2, BorderLayout.SOUTH);

		pack();
		Dimension myDim = getSize();
		Dimension frameDim = f.getSize();
		Dimension screenSize = getToolkit().getScreenSize();
		Point loc = f.getLocation();

		loc.translate((frameDim.width - myDim.width) / 2,
				(frameDim.height - myDim.height) / 2);

		loc.x = Math
				.max(0, Math.min(loc.x, screenSize.width - getSize().width));
		loc.y = Math.max(0,
				Math.min(loc.y, screenSize.width - getSize().height));

		setLocation(loc.x, loc.y);
		show();
	}

	public void actionPerformed(ActionEvent evt) {
		dispose();
	}

	class WindowEventHandler extends WindowAdapter {
		public void windowClosing(WindowEvent evt) {
			dispose();
		}
	}

	class NewdlgButtonListener implements ActionListener {
		public void actionPerformed(ActionEvent event) {
			Object ib = event.getSource();
			if (ib == IDCANCEL)
				dispose();
			else if (ib == IDOK) {
				String val = name.getText();
				if (val.equals(""))
					System.out.println("must have name!");
				else {
					userDefType ne = new userDefType(" ", val);
					m_Parent.setroot(ne);
					m_Parent.outputPanel.repaint();
					m_Parent.outputPanel.validate();
				}
				dispose();
			}
		}
	}

}

// *************************************************
// For drawing graph
// *************************************************

class OutputPanel extends Panel implements MouseListener {
	VisualType parent;

	public OutputPanel(VisualType p) {
		parent = p;
		addMouseListener(this);
	}

	public void mouseClicked(MouseEvent evt) {
		Type root = parent.getroot();
		Type type = isIn(root, evt.getX(), evt.getY());
		if (type != null)
			new InsertDialog(parent.thisframe, (userDefType) type);
	}

	public void mouseEntered(MouseEvent evt) {
	}

	public void mouseExited(MouseEvent evt) {
	}

	public void mousePressed(MouseEvent evt) {
	}

	public void mouseReleased(MouseEvent evt) {
	}

	public void paint(Graphics g) {
		setBackground(Color.black);
		setFont(new Font("Serif", Font.PLAIN, 16));
		Type root = parent.getroot();
		if (root != null) {
			root.placeAt(400, 50);
			setxy();
			root.drawIt(g);
		}
	}

	public void setxy() {
		Type root = parent.getroot();
		Type array[][] = new Type[100][100];
		int count[] = new int[100];
		count[0] = 1;
		array[0][0] = root;
		int lay = 0;
		int c = 1;
		while (c > 0) {
			c = 0;
			for (int i = 0; i < count[lay]; i++)
				if (array[lay][i] instanceof userDefType)
					for (Enumeration e = ((userDefType) array[lay][i])
							.getVector().elements(); e.hasMoreElements();) {
						array[lay + 1][c] = (Type) e.nextElement();
						c++;
					}
			count[lay + 1] = c;
			lay++;
			for (int i = 0; i < c; i++)
				array[lay][i].placeAt(800 * (i + 1) / (c + 1), lay * 50 + 50);
		}
	}

	public Type isIn(Type t, int x, int y) {
		if (t == null)
			return null;
		if (t.isIn(x, y))
			return t;
		else if (t instanceof userDefType) {
			for (Enumeration e = ((userDefType) t).getVector().elements(); e
					.hasMoreElements();) {
				Type t2 = (Type) e.nextElement();
				if (t2 instanceof userDefType) {
					Type gett = isIn(t2, x, y);
					if (gett != null)
						return gett;
				}
			}
			return null;
		} else
			return null;
	}
}

// *************************************************
//
// Students need program for it
// *************************************************

class Oval extends BasicShape {
	public Oval(String n) {
		super(n);
	}

	public void drawIt(Graphics g) {
		g.setColor(Color.red);
		g.fillOval(x - 30, y - 10, 60, 20);
		super.drawIt(g);
	}
}

// *************************************************
//
// Students need program for it
// *************************************************

class Rect extends BasicShape {
	public Rect(String n) {
		super(n);
	}

	public void drawIt(Graphics g) {
		g.setColor(Color.magenta);
		g.fillRect(x - 30, y - 10, 60, 20);
		super.drawIt(g);
	}
}

// *************************************************
// To show the Help dialog.
// You can put your own "msg" here
// *************************************************

class ResultDialog extends Dialog implements ActionListener {
	TextArea result;

	ResultDialog(Frame f) {
		super(f, "Result", true);

		Button b = new Button("OK");
		TextArea msgArea = new TextArea(((VisualType) f).getroot().buildCode2());

		b.addActionListener(this);
		addWindowListener(new WindowEventHandler());

		add(msgArea, BorderLayout.NORTH);
		add(b, BorderLayout.SOUTH);

		pack();
		Dimension myDim = getSize();
		Dimension frameDim = f.getSize();
		Dimension screenSize = getToolkit().getScreenSize();
		Point loc = f.getLocation();

		loc.translate((frameDim.width - myDim.width) / 2,
				(frameDim.height - myDim.height) / 2);

		loc.x = Math
				.max(0, Math.min(loc.x, screenSize.width - getSize().width));
		loc.y = Math.max(0,
				Math.min(loc.y, screenSize.width - getSize().height));

		setLocation(loc.x, loc.y);
		show();
	}

	public void actionPerformed(ActionEvent evt) {
		dispose();
	}

	class WindowEventHandler extends WindowAdapter {
		public void windowClosing(WindowEvent evt) {
			dispose();
		}
	}
}

// *************************************************
//
// Students need program for it
// *************************************************

class RoundRect extends BasicShape {
	public RoundRect(String n) {
		super(n);
	}

	public void drawIt(Graphics g) {
		g.setColor(Color.orange);
		g.fillRoundRect(x - 30, y - 10, 60, 20, 10, 10);
		super.drawIt(g);
	}
}

// *************************************************
//
// Students need program for it
// *************************************************

interface Shape {
	public void placeAt(int x0, int y0);

	public void drawIt(Graphics g);

	public boolean isIn(int x0, int y0);

	public void drawLink(Graphics g, Shape e2);

	public int getX();

	public int getY();
}

// *************************************************
//
// Students need to program for it
// *************************************************

class stringType extends Type {
	public stringType(String n) {
		super(n);
		shape = new Oval(n);
	}

	public String buildCode() {
		return "  String " + name + ";\n";
	}
}

// *************************************************
//
// Students need program for it
// *************************************************

class Triangle extends BasicShape {
	protected String className;

	public Triangle(String n1, String n2) {
		super(n1);
		className = n2;
	}

	public void drawIt(Graphics g) {
		g.setColor(Color.blue);
		int xp[] = new int[3];
		int yp[] = new int[3];
		xp[0] = x - 30;
		yp[0] = y + 20;
		xp[1] = x + 30;
		yp[1] = y + 20;
		xp[2] = x;
		yp[2] = y - 20;
		g.fillPolygon(xp, yp, 3);

		g.setColor(Color.green);
		FontMetrics fontM = g.getFontMetrics();
		int newx, newy;
		newx = x - fontM.stringWidth(className) / 2;
		newy = y + fontM.getHeight() / 2;
		g.drawString(className, newx, newy + fontM.getAscent());
		super.drawIt(g);
	}

	public boolean isIn(int x0, int y0) {
		if ((x0 > x - 20) && (x0 < x + 20) && (y0 > y - 20) && (y0 < y + 20))
			return true;
		return false;
	}
}

// *************************************************
//
// Students need to program for it
// *************************************************

class Type {
	protected String name;
	protected Shape shape;

	public Type() {
	}

	public Type(String n) {
		name = n;
	}

	public String buildCode() {
		return " ";
	}

	public void placeAt(int x, int y) {
		shape.placeAt(x, y);
	}

	public void drawIt(Graphics g) {
		shape.drawIt(g);
	}

	public boolean isIn(int x, int y) {
		return shape.isIn(x, y);
	}

	public void drawLink(Graphics g, Type e2) {
		shape.drawLink(g, e2.shape);
	}
}

// *************************************************
//
// Students need to program for it
// *************************************************

class userDefType extends Type {
	private Vector children = new Vector(10);
	private String className;

	public Vector getVector() {
		return children;
	}

	public void drawIt(Graphics g) {
		for (Enumeration e = children.elements(); e.hasMoreElements();) {
			Type e2 = (Type) e.nextElement();
			drawLink(g, e2);
			e2.drawIt(g);
		}
		shape.drawIt(g);
	}

	public userDefType(String n1, String n2) {
		super(n1);
		className = n2;
		shape = new Triangle(n1, n2);
	}

	public String buildCode() {
		return "  " + className + " " + name + ";\n";
	}

	public String buildCode2() {
		String result = "class " + className + "\n{\n";
		for (Enumeration e = children.elements(); e.hasMoreElements();)
			result += ((Type) e.nextElement()).buildCode();
		result += "}\n";

		for (Enumeration e = children.elements(); e.hasMoreElements();) {
			Type t = (Type) e.nextElement();
			if (t instanceof userDefType)
				result += ((userDefType) t).buildCode2();
		}
		return result;
	}

	public void insert(Type c) {
		children.addElement(c);
	}
}

// *************************************************
// Main program
//
// *************************************************

public class VisualType extends Frame {
	static OutputPanel outputPanel;
	Button newButton, doButton, clearButton, quitButton, helpButton;
	static private userDefType root;
	ButtonListener buttonListener = new ButtonListener();
	static Frame thisframe;

	VisualType() {
		super("VisualType");
		thisframe = this;

		addNotify();
		addWindowListener(new WindowEventHandler());
		Insets insets = getInsets();
		setSize(insets.left + insets.right + 800, insets.top + insets.bottom
				+ 600);

		Panel inputPanel, buttonPanel;
		setLayout(new BorderLayout());

		inputPanel = new Panel();
		inputPanel.setLayout(new BorderLayout());

		buttonPanel = new Panel();
		newButton = new Button("New Type");
		newButton.addActionListener(buttonListener);
		buttonPanel.add(newButton);

		doButton = new Button("Build Code");
		doButton.addActionListener(buttonListener);
		buttonPanel.add(doButton);

		clearButton = new Button("Clear");
		clearButton.addActionListener(buttonListener);
		buttonPanel.add(clearButton);

		quitButton = new Button("Quit");
		quitButton.addActionListener(buttonListener);
		buttonPanel.add(quitButton);

		helpButton = new Button("Help");
		helpButton.addActionListener(buttonListener);
		buttonPanel.add(helpButton);

		inputPanel.add("North", new Label(
				"CSE 505  Java Project:  Visual Type", Label.CENTER));

		inputPanel.add("Center", buttonPanel);

		add("North", inputPanel);

		outputPanel = new OutputPanel(this);
		add("Center", outputPanel);
	}

	public userDefType getroot() {
		return root;
	}

	public void setroot(userDefType r) {
		root = r;
	}

	public void cleartree() {
		root = null;
	}

	class WindowEventHandler extends WindowAdapter {
		public void windowClosing(WindowEvent evt) {
			dispose();
			System.exit(0);
		}
	}

	class ButtonListener implements ActionListener {
		public void actionPerformed(ActionEvent event) {
			Object ib = event.getSource();
			if (ib == newButton)
				new NewDialog(thisframe);
			else if (ib == doButton)
				if (root != null)
					new ResultDialog(thisframe);
				else
					System.out.println("Need to create Type first!");
			else if (ib == clearButton) {
				cleartree();
				outputPanel.repaint();
			} else if (ib == helpButton)
				new HelpDialog(thisframe);
			else if (ib == quitButton)
				System.exit(0);
		}
	}

	static public void main(String[] args) {
		(new VisualType()).show();
	}
}