package edu.buffalo.cse.jive.app.bst.animation;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;

import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import edu.buffalo.cse.jive.app.bst.View;

public class TreeGUI extends JFrame {

	private static final long serialVersionUID = 435602610901916317L;

	private final JButton btnLoad;
	private final JTextField edFileName;
	private final JPanel pnTop;
	private final TreePanel pnTree;
	private volatile boolean uiDone = false;
	private final View view;

	public TreeGUI(final View client) {

		this.view = client;
		setDefaultCloseOperation(DISPOSE_ON_CLOSE);
		edFileName = new JTextField(40);
		edFileName.setEditable(false);

		btnLoad = new JButton("Load...");
		btnLoad.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(final ActionEvent e) {

				edFileName.setText("");
				final JFileChooser fc = new JFileChooser();
				if (fc.showOpenDialog(TreeGUI.this) == JFileChooser.APPROVE_OPTION) {
					edFileName.setText(fc.getSelectedFile().getPath());
					view.loadModel(fc.getSelectedFile());
				}
			}
		});

		final JPanel input1 = new JPanel();
		input1.add(new JLabel("Tree file:"));
		input1.add(edFileName);
		input1.add(btnLoad);

		pnTop = new JPanel();
		pnTop.setLayout(new BorderLayout());
		pnTop.add("North", input1);

		pnTree = new TreePanel();
		pnTree.setOpaque(true);
		pnTree.setBackground(Color.WHITE);
		pnTree.addComponentListener(new ComponentAdapter() {

			@Override
			public void componentResized(final ComponentEvent e) {

				update();
			}
		});

		setLayout(new BorderLayout());
		add("North", pnTop);
		add("Center", pnTree);
		setPreferredSize(new Dimension(1200, 800));
	}

	@Override
	public void dispose() {

		setDone();
		super.dispose();
	}

	public void update() {

		// block any pending updates on the event queue after dispose
		if (uiDone) {
			System.err.println("update::done");
			return;
		}
		repaint();
		pnTree.drawTree(view.getModel().getTree());
	}

	public void setDone() {

		this.uiDone = true;
	}

	public boolean done() {

		return uiDone;
	}
}