package edu.buffalo.cse.jive.app.dblp.model;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.channels.FileChannel;

public abstract class WriterFactory {

  public abstract Persister defaultPersister() throws IOException;

  public final FileChannel newFileChannel(final String fileName) throws FileNotFoundException {

    return new FileOutputStream(fileName, true).getChannel();
  }

  public final OutputStream newOutputStream(final String fileName) throws FileNotFoundException {

    return new BufferedOutputStream(new FileOutputStream(fileName, true), 8 * 1024);
  }

  public final Writer newWriter(final String fileName) throws FileNotFoundException {

    return new OutputStreamWriter(newOutputStream(fileName));
  }
}