package edu.buffalo.cse.jive.app.dblp.sql;

import edu.buffalo.cse.jive.app.dblp.model.Entity;

class SQLStatements {

  private static final String SQLFMT_LOOKUP = "INSERT INTO %s VALUES(%d, '%s');\n";
  private static final String SQLFMT_ENTITY = "INSERT INTO %s VALUES(%d, '%s', '%s', '%s', '%s');\n";
  private static final String SQLFMT_ENTITY_ONEMANY_BY_ID = "INSERT INTO %s VALUES(%d, %d);\n";
  private static final String SQLFMT_ENTITY_ONEMANY_BY_VALUE = "INSERT INTO %s VALUES(%d, '%s');\n";

  // private static final String SQLFMT_ENTITY_CHILD =
  // "INSERT INTO %s VALUES(%d, '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s');\n";

  private static final String SQLFMT_ENTITY_ARTICLE = "INSERT INTO %s VALUES(%d, '%s', '%s', '%s', '%s', '%s');\n";
  private static final String SQLFMT_ENTITY_BOOK = "INSERT INTO %s VALUES(%d, '%s', '%s', '%s', '%s');\n";
  private static final String SQLFMT_ENTITY_INCOLLECTION = "INSERT INTO %s VALUES(%d, '%s', '%s', '%s', '%s');\n";
  private static final String SQLFMT_ENTITY_INPROCEEDINGS = "INSERT INTO %s VALUES(%d, '%s', '%s', '%s', '%s');\n";
  private static final String SQLFMT_ENTITY_MSTHESIS = "INSERT INTO %s VALUES(%d, '%s', '%s');\n";
  private static final String SQLFMT_ENTITY_PHDTHESIS = "INSERT INTO %s VALUES(%d, '%s', '%s');\n";
  private static final String SQLFMT_ENTITY_PROCEEDINGS = "INSERT INTO %s VALUES(%d, '%s', '%s', '%s', '%s');\n";

  private static final String TN_ENTITY = "DBLP_ENTITY";
  private static final String TN_AUTHOR = "DBLP_AUTHOR";
  private static final String TN_EDITOR = "DBLP_EDITOR";
  private static final String TN_PUBLISHER = "DBLP_PUBLISHER";

  private static final String TN_ENTITY_ARTICLE = TN_ENTITY + "_ARTICLE";
  private static final String TN_ENTITY_BOOK = TN_ENTITY + "_BOOK";
  private static final String TN_ENTITY_INCOLLECTION = TN_ENTITY + "_INCOLLECTION";
  private static final String TN_ENTITY_INPROCEEDINGS = TN_ENTITY + "_INPROCEEDINGS";
  private static final String TN_ENTITY_MSTHESIS = TN_ENTITY + "_MSTHESIS";
  private static final String TN_ENTITY_PHDTHESIS = TN_ENTITY + "_PHDTHESIS";
  private static final String TN_ENTITY_PROCEEDINGS = TN_ENTITY + "_PROCEEDINGS";

  private static final String TN_ENTITY_AUTHOR = TN_ENTITY + "_AUTHOR";
  private static final String TN_ENTITY_EDITOR = TN_ENTITY + "_EDITOR";
  private static final String TN_ENTITY_PUBLISHER = TN_ENTITY + "_PUBLISHER";

  private static final String TN_ENTITY_CDROM = TN_ENTITY + "_CDROM";
  private static final String TN_ENTITY_CITE = TN_ENTITY + "_CITE";
  private static final String TN_ENTITY_EE = TN_ENTITY + "_EE";
  private static final String TN_ENTITY_ISBN = TN_ENTITY + "_ISBN";
  private static final String TN_ENTITY_NOTE = TN_ENTITY + "_NOTE";
  private static final String TN_ENTITY_URL = TN_ENTITY + "_URL";

  public String getEntity(Entity entity) {

    return String.format(SQLFMT_ENTITY, TN_ENTITY, entity.getId(), entity.getKey(),
        entity.getMdate(), entity.getType(), entity.getTitle());
  }

  public String getChild(Entity entity) {

    switch (entity.getType()) {
      case article:
        return String.format(SQLFMT_ENTITY_ARTICLE, TN_ENTITY_ARTICLE, entity.getId(),
            entity.getJournal(), entity.getNumber(), entity.getPages(), entity.getVolume(),
            entity.getYear());
      case book:
        return String.format(SQLFMT_ENTITY_BOOK, TN_ENTITY_BOOK, entity.getId(),
            entity.getBooktitle(), entity.getSeries(), entity.getVolume(), entity.getYear());
      case incollection:
        return String.format(SQLFMT_ENTITY_INCOLLECTION, TN_ENTITY_INCOLLECTION, entity.getId(),
            entity.getBooktitle(), entity.getCrossref(), entity.getPages(), entity.getYear());
      case inproceedings:
        return String.format(SQLFMT_ENTITY_INPROCEEDINGS, TN_ENTITY_INPROCEEDINGS, entity.getId(),
            entity.getBooktitle(), entity.getCrossref(), entity.getPages(), entity.getYear());
      case mastersthesis:
        return String.format(SQLFMT_ENTITY_MSTHESIS, TN_ENTITY_MSTHESIS, entity.getId(),
            entity.getSchool(), entity.getYear());
      case phdthesis:
        return String.format(SQLFMT_ENTITY_PHDTHESIS, TN_ENTITY_PHDTHESIS, entity.getId(),
            entity.getSchool(), entity.getYear());
      case proceedings:
        return String.format(SQLFMT_ENTITY_PROCEEDINGS, TN_ENTITY_PROCEEDINGS, entity.getId(),
            entity.getBooktitle(), entity.getSeries(), entity.getVolume(), entity.getYear());
        // default:
        // return String.format(SQLFMT_ENTITY_CHILD, entity.getType(), entity.getId(), entity
        // .getAddress(), entity.getBooktitle(), entity.getChapter(), entity.getCrossref(), entity
        // .getJournal(), entity.getMonth(), entity.getNumber(), entity.getPages(), entity
        // .getSchool(), entity.getSeries(), entity.getVolume(), entity.getYear());
    }
    return null;
  }

  public String getEntityAuthor(Entity entity, Integer authorId) {

    return getOneToManyById(entity, TN_ENTITY_AUTHOR, authorId);
  }

  public String getEntityEditor(Entity entity, Integer editorId) {

    return getOneToManyById(entity, TN_ENTITY_EDITOR, editorId);
  }

  public String getEntityPublisher(Entity entity, Integer publisherId) {

    return getOneToManyById(entity, TN_ENTITY_PUBLISHER, publisherId);
  }

  public String getEntityCdrom(Entity entity, String cdrom) {

    return getOneToManyByValue(entity, TN_ENTITY_CDROM, cdrom);
  }

  public String getEntityCite(Entity entity, String cite) {

    return getOneToManyByValue(entity, TN_ENTITY_CITE, cite);
  }

  public String getEntityEe(Entity entity, String ee) {

    return getOneToManyByValue(entity, TN_ENTITY_EE, ee);
  }

  public String getEntityIsbn(Entity entity, String isbn) {

    return getOneToManyByValue(entity, TN_ENTITY_ISBN, isbn);
  }

  public String getEntityNote(Entity entity, String note) {

    return getOneToManyByValue(entity, TN_ENTITY_NOTE, note);
  }

  public String getEntityUrl(Entity entity, String url) {

    return getOneToManyByValue(entity, TN_ENTITY_URL, url);
  }

  public String getLookupAuthor(int authorId, String author) {

    return String.format(SQLFMT_LOOKUP, TN_AUTHOR, authorId, author);
  }

  public String getLookupEditor(int editorId, String editor) {

    return String.format(SQLFMT_LOOKUP, TN_EDITOR, editorId, editor);
  }

  public String getLookupPublisher(int publisherId, String publisher) {

    return String.format(SQLFMT_LOOKUP, TN_PUBLISHER, publisherId, publisher);
  }

  private String getOneToManyById(Entity entity, String tableName, Integer id) {

    return String.format(SQLFMT_ENTITY_ONEMANY_BY_ID, tableName, entity.getId(), id);
  }

  private String getOneToManyByValue(Entity entity, String tableName, String value) {

    return String.format(SQLFMT_ENTITY_ONEMANY_BY_VALUE, tableName, entity.getId(), value);
  }
}