package edu.buffalo.cse.jive.app.linkedlist.driver;

import edu.buffalo.cse.jive.app.linkedlist.ListFactory;
import edu.buffalo.cse.jive.app.linkedlist.ListFactory.JiveIntList;

/**
 * JIVE Demo: driver for the IntLinkedList implementation of the int list.
 */
public class IntLinkedListDriver extends ListDriver {

  private JiveIntList myList;

  protected void show() {

    System.out.println(myList + ":" + myList.size());
  }

  protected void insert(int value) {

    myList.insert(value);
    if (traceOn) {
      show();
    }
  }

  protected void remove(int value) {

    myList.remove(value);
    if (traceOn) {
      show();
    }
  }

  protected void newList() {

    myList = ListFactory.createIntList();
  }

  public static void main(String args[]) {

    driver = new IntLinkedListDriver();
    driver.firstTest();
    driver.secondTest();
  }
}