package edu.buffalo.cse.jive.app.linkedlist.driver;

/**
 * JIVE Demo: generic driver for lists.
 * 
 * @change 2010-09-15 - created classes in order to generalize all list driver
 *         tests.
 * 
 * @author Demian Lessa
 * 
 */
public abstract class ListDriver {

	protected boolean traceOn;
	protected static ListDriver driver;

	public ListDriver() {

		traceOn = true;
	}

	protected abstract void show();

	protected abstract void insert(int value);

	protected abstract void remove(int value);

	protected abstract void newList();

	protected void traceOn() {

		traceOn = true;
	}

	protected void traceOff() {

		traceOn = false;
	}

	protected void firstTest() {

		newList();
		insert(10);
		insert(40);
		insert(20);
		insert(40);
		insert(-20);
		insert(65);
		insert(20);
		insert(12);
		insert(17);
		remove(20);
		remove(-20);
		remove(65);
		remove(40);
		remove(17);
		remove(10);
		remove(20);
		remove(40);
		remove(10);
	}

	protected void secondTest() {

		newList();
		insert(20);
		insert(10);
		insert(40);
		insert(40);
		insert(-20);
		insert(65);
		insert(20);
		insert(12);
		insert(17);
		remove(20);
		remove(-20);
		remove(65);
		remove(40);
		remove(17);
		remove(10);
		remove(20);
		remove(40);
		remove(12);
	}
}