package edu.buffalo.cse.jive.app.sorting;


final class BubbleSort<T extends Comparable<T>> extends SortAlgorithm<T> {

  BubbleSort(final SortableCollection<T> values, final SortAlgorithmFactory factory,
      final boolean isAnimated) {

    super(AlgorithmId.BUBBLE_SORT, values, factory, isAnimated);
  }

  @Override
  protected void sort() {

    final int size = getData().size();
    for (int i = size; --i >= 0;) {
      boolean swapped = false;
      for (int j = 0; j < i; j++) {
        if (compare(j, j + 1) > 0) {
          swap(j, j + 1);
          swapped = true;
        }
      }
      if (!swapped) {
        return;
      }
    }
  }
}