package edu.buffalo.cse.jive.app.sorting;


final class InsertionSort<T extends Comparable<T>> extends SortAlgorithm<T> {

  InsertionSort(final SortableCollection<T> values, final SortAlgorithmFactory factory,
      final boolean isAnimated) {

    super(AlgorithmId.INSERTION_SORT, values, factory, isAnimated);
  }

  private void insertInOrder(final int first, final int last, final int unsorted) {

    int index = first;
    while ((index <= last) && (compare(index, unsorted) < 0)) {
      index++;
    }
    for (int swapPos = unsorted; swapPos > index; swapPos--) {
      swap(swapPos, swapPos - 1);
    }
  }

  @Override
  protected void sort() {

    final int size = getData().size();
    for (int i = 1; i < size; i++) {
      insertInOrder(0, i - 1, i);
    }
  }
}