package edu.buffalo.cse.jive.app.sorting;


final class MergeSort<T extends Comparable<T>> extends SortAlgorithm<T> {

  MergeSort(final SortableCollection<T> values, final SortAlgorithmFactory factory,
      final boolean isAnimated) {

    super(AlgorithmId.MERGE_SORT, values, factory, isAnimated);
  }

  private void mergeSort(final int lo0, final int hi0) {

    int lo = lo0;
    final int hi = hi0;
    if (lo >= hi) {
      return;
    }
    final int mid = (lo + hi) / 2; /*
                                    * * Partition the list into two lists and sort them
                                    * recursively
                                    */
    mergeSort(lo, mid);
    mergeSort(mid + 1, hi); /* * Merge the two sorted lists */
    int end_lo = mid;
    int start_hi = mid + 1;
    while ((lo <= end_lo) && (start_hi <= hi)) {
      if (compare(lo, start_hi) < 0) {
        lo++;
      }
      else { /*
              * a[lo] >= a[start_hi]
              * 
              * The next element comes from the second list, move the a[start_hi] element into the
              * next position and shuffle all the other elements up.
              */
        final int unsorted = start_hi;
        for (int swapPos = lo; swapPos < unsorted; swapPos++) {
          swap(swapPos, unsorted);
        }
        lo++;
        end_lo++;
        start_hi++;
      }
    }
  }

  @Override
  protected void sort() {

    mergeSort(0, getData().size() - 1);
  }
}