package edu.buffalo.cse.jive.app.sorting;

import java.util.concurrent.CountDownLatch;

final class Sorter implements Runnable {

  private final CountDownLatch startSignal;
  private final CountDownLatch endSignal;
  private final SortAlgorithm<? extends Comparable<?>> algorithm;

  <E extends Comparable<E>> Sorter(final CountDownLatch startSignal,
      final CountDownLatch endSignal, final SortAlgorithm<E> algorithm) {

    this.startSignal = startSignal;
    this.endSignal = endSignal;
    this.algorithm = algorithm;
  }

  @Override
  public void run() {

    try {
      startSignal.await();
      algorithm.sort();
      algorithm.done();
      endSignal.countDown();
    }
    catch (final InterruptedException e) {
      e.printStackTrace();
    }
  }
}