package edu.buffalo.cse.jive.benchmarks;

import java.io.File;

import edu.buffalo.cse.jive.app.bst.Controller;
import edu.buffalo.cse.jive.app.bst.Controller.ControllerException;
import edu.buffalo.cse.jive.benchmarks.Benchmark.BenchmarkException;

class BenchmarkBSTAnimation extends Benchmark {

  private static final String BST_10 = "data/bsta-10.txt";
  private static final String BST_20 = "data/bsta-20.txt";
  private static final String BST_30 = "data/bsta-30.txt";
  private static final String BST_40 = "data/bsta-40.txt";
  private static final String BST_50 = "data/bsta-50.txt";

  private static String BST = "/home/demian/bst-script2.txt";

  public static void main(final String[] args) throws BenchmarkException {

    new BenchmarkBSTAnimation().doRun();
  }

  @Override
  protected String name() {

    return "BST Animation " + BST;
  }

  @Override
  public void doRun() throws BenchmarkException {

    final Controller c = new Controller(true);
    try {
      c.showView();
      c.loadModel(new File(BST));
      c.waitForWorker();
      c.closeView();
    }
    catch (final ControllerException ce) {
      throw new BenchmarkException(ce);
    }
  }
}