package edu.buffalo.cse.jive.benchmarks;

import java.util.Iterator;

import edu.buffalo.cse.jive.benchmarks.Benchmark.BenchmarkException;
import etomica.graph.isomorphism.Match;
import etomica.graph.iterators.DefaultIterator;
import etomica.graph.iterators.filters.IsomorphismFilter;
import etomica.graph.model.Graph;

class BenchmarkGraphsIsomorphFree extends Benchmark {

  private static final byte NODE_COUNT_3 = 3;
  private static final byte NODE_COUNT_4 = 4;
  private static final byte NODE_COUNT_5 = 5;
  private static final byte NODE_COUNT_6 = 6;

  private static byte NODE_COUNT;

  public static void main(final String[] args) throws BenchmarkException {

    NODE_COUNT = NODE_COUNT_3;
    Benchmark.run(BenchmarkGraphsIsomorphFree.class, 1);
  }

  @Override
  protected String name() {

    return "Isomorph-Free Graph Set Generation-" + NODE_COUNT;
  }

  @Override
  protected void doRun() throws BenchmarkException {

    int enumerated = 0;
    final boolean printPermutations = false;
    final int expected = Match.ISMORPHS_COUNT[NODE_COUNT - 1];
    final Iterator<Graph> iterator = new IsomorphismFilter(new DefaultIterator(NODE_COUNT));
    while (iterator.hasNext()) {
      enumerated++;
      if (printPermutations) {
        message(iterator.next().toString());
      }
      else {
        iterator.next();
      }
    }
    if (enumerated != expected) {
      message("Expected %d isomorph-free graphs with %d nodes, but enumerated %d graphs.",
          expected, NODE_COUNT, enumerated);
    }
    // else {
    // message("%d isomorph-free graphs with %d nodes enumerated.", expected, NODE_COUNT);
    // }
  }
}
