package edu.buffalo.cse.jive.benchmarks;

import java.io.IOException;
import java.util.List;

import edu.buffalo.cse.jive.app.concurrency.ProducerConsumerFactory;
import edu.buffalo.cse.jive.app.concurrency.ProducerConsumerFactory.Basket;
import edu.buffalo.cse.jive.app.concurrency.ProducerConsumerFactory.Consumer;
import edu.buffalo.cse.jive.app.concurrency.ProducerConsumerFactory.Producer;
import edu.buffalo.cse.jive.data.DataFactory;

class BenchmarkProducerConsumer extends Benchmark {

  private static final String BASKET_10 = "data/bst-10.txt";
  private static final String BASKET_50 = "data/bst-50.txt";
  private static final String BASKET_100 = "data/bst-100.txt";
  private static final String BASKET_500 = "data/bst-500.txt";
  private static final String BASKET_1000 = "data/bst-1000.txt";

  private static String BASKET;

  public static void main(final String[] args) throws BenchmarkException {

    BASKET = BASKET_10;
    BASKET = BASKET_50;
    BASKET = BASKET_100;
    BASKET = BASKET_500;
    BASKET = BASKET_1000;
    Benchmark.run(BenchmarkProducerConsumer.class, 1);
  }

  @Override
  protected String name() {

    return "Producer/Consumer-" + BASKET;
  }

  @Override
  public void doRun() throws BenchmarkException {

    final Basket basket = ProducerConsumerFactory.createBasket();
    final Consumer c = ProducerConsumerFactory.createConsumer(basket);
    List<String> list;
    try {
      list = DataFactory.loadAsStringList(getResource(BASKET).getPath());
    }
    catch (final IOException ioe) {
      throw new BenchmarkException(ioe);
    }
    list.add("DONE");
    final Producer p = ProducerConsumerFactory.createProducer(basket, list.toArray(new String[0]));
    final Thread ct = (new Thread(c));
    final Thread pt = (new Thread(p));
    pt.start();
    ct.start();
    try {
      ct.join();
      pt.join();
    }
    catch (final InterruptedException ie) {
      throw new BenchmarkException(ie);
    }
  }
}
