package edu.buffalo.cse.jive.benchmarks;

import edu.buffalo.cse.jive.app.sorting.SortApplication;

class BenchmarkSorting extends Benchmark {

  private static int DATA_SIZE_10 = 10;
  private static int DATA_SIZE_50 = 50;
  private static int DATA_SIZE_100 = 100;
  private static int DATA_SIZE_500 = 500;
  private static int DATA_SIZE_1000 = 1000;

  private static int DATA_SIZE;

  public static void main(final String[] args) throws BenchmarkException {

    DATA_SIZE = DATA_SIZE_10;
    DATA_SIZE = DATA_SIZE_50;
    DATA_SIZE = DATA_SIZE_100;
    DATA_SIZE = DATA_SIZE_500;
    DATA_SIZE = DATA_SIZE_1000;
    Benchmark.run(BenchmarkSorting.class, 5);
  }

  @Override
  public void doRun() throws BenchmarkException {

    final SortApplication sorter = new SortApplication(DATA_SIZE);
    sorter.start();
  }

  @Override
  protected String name() {

    return "Sorting " + DATA_SIZE;
  }
}