package edu.buffalo.cse.jive.benchmarks;

import edu.buffalo.cse.jive.app.sorting.animation.SortAnimation;

class BenchmarkSortingAnimation extends Benchmark {

  private static int DATA_SIZE_10 = 10;
  private static int DATA_SIZE_20 = 20;
  private static int DATA_SIZE_30 = 30;
  private static int DATA_SIZE_40 = 40;
  private static int DATA_SIZE_50 = 50;

  private static int DATA_SIZE;

  public static void main(final String[] args) throws BenchmarkException {

    DATA_SIZE = DATA_SIZE_10;
    DATA_SIZE = DATA_SIZE_20;
    DATA_SIZE = DATA_SIZE_30;
//    DATA_SIZE = DATA_SIZE_40;
//    DATA_SIZE = DATA_SIZE_50;
    Benchmark.run(BenchmarkSortingAnimation.class, 1);
  }

  @Override
  protected String name() {

    return "Sorting Animation " + DATA_SIZE;
  }

  @Override
  public void doRun() throws BenchmarkException {

    final SortAnimation animation = new SortAnimation(DATA_SIZE, true);
    animation.show();
    while (!animation.isDone()) {
      try {
        Thread.sleep(100);
      }
      catch (final InterruptedException ie) {
        // cowardly ignore
        ie.printStackTrace();
      }
    }
  }
}