;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: MULTI; Base: 10 -*-

;; Copyright (C) 1984--2004
;; Research Foundation of State University of New York

;; Version: $Id: multi-changes.lisp,v 1.8 2004/08/26 23:24:38 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science and Engineering,
;; University at Buffalo, The State University of New York, 
;; 201 Bell Hall, Buffalo, NY 14260, USA

(in-package :multi)


;; Contains updated versions of `schedule' and `multip' which indicate
;; the state of a node process by changing the filling style of the
;; according XGinseng node:

(defun is-node-process (process)
  ;; Returns T if PROCESS is a node process.
  ;; Returns NIL for processes such as USER, POSUSER, etc.
  (member 'snip::*NODE* (get (car (eval process)) 'lregs%)))

(defun schedule (event queue)
  (cond ((eq (regfetch event '*PRIORITY*) 'snip::INTEND) ; intended acts
         (dequeue:insert-front event queue))            ; go on front -dk
	((dequeue:in-queue event queue) queue)
	((eq (regfetch event '*NAME*) 'snip:USER)
	 (dequeue:insert-front event queue))
	(t (if (is-node-process event)
               (xginseng::set-fillstyle.n
                (regfetch event 'snip::*NODE*)
                :initiated))
	   (dequeue:insert-rear event queue))))

(defun multip (actq hpq lpq)
  "Evaluates processes"
  (let ((*act-queue* actq)
	(*high-priority-queue* hpq)
	(*low-priority-queue* lpq)
	highest-priority-non-empty-queue
	*NAME*)
    (declare (optimize (speed 3))
	     (special *NAME*))
    (prog (curnt% regvals)
       loop
          (cond (*trace-enabled*
		 (format t "~%>>>>>> MULTI QUEUES> A: ")
		 (dequeue::print *act-queue*)
		 (format t ", H: ")
		 (dequeue::print *high-priority-queue*)
		 (format t ", L: ")
		 (dequeue::print *low-priority-queue*)
		 (format t "~%")))
	  (cond ((not (dequeue:empty *high-priority-queue*))
		 (setq highest-priority-non-empty-queue *high-priority-queue*))
		((not (dequeue:empty *low-priority-queue*))
		 (setq highest-priority-non-empty-queue *low-priority-queue*))
		((not (dequeue:empty *act-queue*))
		 (setq highest-priority-non-empty-queue *act-queue*))
		(t (return)))
	  (setq curnt% (dequeue:front highest-priority-non-empty-queue))
	  (setq regvals (eval curnt%))
	  (setq *NAME* (car regvals))
          (if (is-node-process curnt%)
              (xginseng::set-fillstyle.n
               (regfetch curnt% 'snip::*NODE*)
               :executing))
	  (dequeue:delete-front highest-priority-non-empty-queue)
	  (if *trace-enabled*
	      (cond
		((or (eq *trace-events* t)
		     (member (car regvals) *trace-events*))
		 (print-regs curnt% "Entering"))))
	  (apply (symbol-function (car regvals)) regvals)
          (if (is-node-process curnt%)
              (xginseng::set-fillstyle.n
               (regfetch curnt% 'snip::*NODE*)
               :inactive))
	  (if *trace-enabled*
	      (cond
		((or (eq *trace-events* t)
		     (member (car regvals) *trace-events*))
		 (print-regs curnt% "Leaving"))))
      (go loop))))



    
    




