;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNEPSUL; Base: 10 -*-

;; Copyright (C) 1993--2004
;; Research Foundation of State University of New York

;; Version: $Id: blocks.lisp,v 1.7 2004/08/26 23:24:55 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science and Engineering,
;; University at Buffalo, The State University of New York, 
;; 201 Bell Hall, Buffalo, NY 14260, USA

(in-package :snepsul)


(defun use-graphics-p ()
  (and (find-package 'opal)
       (fboundp 'bw-initialize)))

(defun initialize-blocksworld ()
  (if (use-graphics-p)
      (bw-initialize)))


;;; Definitions of primitive blocks world actions:
;;; ==============================================

;;; The definitions below assume that object nodes of blocksworld
;;; actions are represented with `lex' case frames.  For example,
;;; the act "Pick up C" needs to be represented by the following node:
;;;
;;;    (build action (build lex "pickup")
;;;           object1 (build lex "C"))
;;;
;;; This representational assumption is also reflected in the call
;;; to `declare-primitive' in the demo files.

(define-primaction pickup (object1)
  (let ((block (first (ns-to-lisp-list #!((find lex- ~object1))))))
    (format t "~&Now doing: Pickup ~A.~%" block)
    (if (use-graphics-p)
        ;; The name of a SNePS node representing a block
        ;; is bound to its associated Garnet object:
        (bw-pickup (eval block)))))

(define-primaction put (object1 object2)
  (let ((block (first (ns-to-lisp-list #!((find lex- ~object1)))))
        (support (or (first (ns-to-lisp-list #!((find lex- ~object2))))
                     'table)))
    (format t "~&Now doing: Put ~A on ~A.~%" block support)
    (if (use-graphics-p)
        (bw-putdown (eval block)
                    (if (string-equal support 'table)
                        table
                      (eval support))))))

(define-primaction lookat (object1)
  (let ((entity (first (ns-to-lisp-list #!((find lex- ~object1)))))
	(color 'red)
        (*with-snepsul-eval-function* #'with-snepsul-toplevel-style-eval))
    (format t "~&Now doing: Look at ~A~%" entity)
    (if (use-graphics-p)
        (setf color (bw-find-color (eval entity))))
    (let ((sneps-current-context sneps:crntct))
      #!((dynamic-add rel (build lex "color")
		      arg1 ~object1
		      arg2 (build lex ~color)
		      :context ~sneps-current-context)))))



;; Simulated actions of an external agent:

(defsnepscom john-pickup ((block) (top))
  (let ((*with-snepsul-eval-function* #'with-snepsul-toplevel-style-eval))
    (if (use-graphics-p)
        (bw-john-pickup (eval block))
      (format t "~&~%*** John now picks up ~A~2%" block))
    #!((add agent (build lex "john")
            act (build action (build lex "pickup")
                       object1 (build lex ~block))))))

(defsnepscom john-putdown ((block support) (top))
  (let ((*with-snepsul-eval-function* #'with-snepsul-toplevel-style-eval))
    (if (use-graphics-p)
        (bw-john-putdown (eval block) (eval support))
      (format t "~&~%*** John now puts ~A on ~A.~2%" block support))
    #!((add agent (build lex "john")
            act (build action (build lex "put")
                       object1 (build lex ~block)
                       object2 (build lex ~support))))))



    
    




